﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/fs/fs_ResultHandler.h>

namespace nn { namespace os {
    void InitializeVirtualAddressMemory() NN_NOEXCEPT;
}}

namespace nn { namespace diag {

void InitializeApplicationAbortObserver() NN_NOEXCEPT;

}} // namespace nn::diag

extern "C" void nndiagStartup();

namespace nn { namespace fs {

void SetLocalApplicationAccessLog(bool isEnabled) NN_NOEXCEPT;

}} // namespace nn::fs

extern "C" void nninitInitializeSdkModule()
{
    ::nndiagStartup();

    ::nn::os::InitializeVirtualAddressMemory();

    ::nn::fs::SetLocalApplicationAccessLog(true);

    ::nn::fs::SetResultHandledByApplication(true);

    ::nn::diag::InitializeApplicationAbortObserver();
}

extern "C" void nninitFinalizeSdkModule()
{
}
