﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_NativeHandleFwd.h>

void InitializeAllocator() NN_NOEXCEPT;
size_t GetApplicationHeapSize() NN_NOEXCEPT;
size_t GetTotalAllocatedSize() NN_NOEXCEPT;
size_t GetTotalAllocatedSizeMax() NN_NOEXCEPT;

void InitializeGraphics() NN_NOEXCEPT;

void* GetRecorderFirmwareMemory() NN_NOEXCEPT;
size_t GetRecorderFirmwareMemorySize() NN_NOEXCEPT;

nn::sf::NativeHandle MakeTransferMemory(void* memory, size_t size) NN_NOEXCEPT;
