﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testUi2d_CustomTagProcessor.h"

#include <nn/font/font_WideTextWriter.h>

namespace nnt {
namespace ui2d {

nn::font::WideTagProcessor::Operation CustomTagProcessor::ProcessTag(
    uint32_t code,
    nn::font::WideTagProcessor::ContextType* pContext,
    nn::font::Rectangle* pRect)
{
    switch (code)
    {
    case TagDefaultFont:
        pContext->writer->SetFont(m_pDefaultFont);
        break;
    case TagAlternativeFont:
        pContext->writer->SetFont(m_pAlternativeFont);
        break;
    default:
        if (pRect == NULL)
        {
            return nn::font::WideTagProcessor::Process(code, pContext);
        }
        else
        {
            return nn::font::WideTagProcessor::CalculateRect(pRect, pContext, code);
        }
        break;
    }
    return nn::font::WideTagProcessor::Operation_Default;
}

} // namespace ui2d
} // namespace nnt
