﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{GraphicsObject.cpp,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This files defines a simple base class that handles
 *  render state setting for a given loaded model.
 */

#include <nvn/nvn_FuncPtrInline.h>
#include <nvngdSupport/GraphicsObject.h>

/*
 * GraphicsObject Constructor
 * ---------------------------
 * Sets the objects default state.
 */
GraphicsObject::GraphicsObject()
{
        /* Blend State */
    nvnBlendStateSetDefaults(&m_BlendState);

        /* Channel Mask State */
    nvnChannelMaskStateSetDefaults(&m_ChannelMaskState);

        /* Color State */
    nvnColorStateSetDefaults(&m_ColorState);

        /* Depth Stencil State */
    nvnDepthStencilStateSetDefaults(&m_DepthStencilState);

        /* Multisample state */
    nvnMultisampleStateSetDefaults(&m_MultisampleState);

        /* Polygon state */
    nvnPolygonStateSetDefaults(&m_PolygonState);
}

/*
 * GraphicsObject Destructor
 * --------------------------
 * Empty destructor.
 */
GraphicsObject::~GraphicsObject()
{
}

/*
 * GraphicsObject::SetDefaultState
 * -------------------------------
 * Sets the render states back to defaults.
 */
void GraphicsObject::SetDefaultState()
{
    nvnDepthStencilStateSetDefaults(&m_DepthStencilState);

    nvnPolygonStateSetDefaults(&m_PolygonState);

    nvnMultisampleStateSetDefaults(&m_MultisampleState);

    nvnColorStateSetDefaults(&m_ColorState);

    nvnChannelMaskStateSetDefaults(&m_ChannelMaskState);

    nvnBlendStateSetDefaults(&m_BlendState);
}

/*
 * GraphicsObject::GetName
 * --------------------------
 * Gets the name of the asset file the object
 * is associated with.
 */
const std::string& GraphicsObject::GetName() const
{
    return m_Name;
}

/*
 * GraphicsObject::BindState
 * --------------------------
 * Binds the render states to a given command buffer.
 */
void GraphicsObject::BindState(NVNcommandBuffer* pCommandBuffer) const
{
    nvnCommandBufferBindBlendState(pCommandBuffer, &m_BlendState);
    nvnCommandBufferBindChannelMaskState(pCommandBuffer, &m_ChannelMaskState);
    nvnCommandBufferBindColorState(pCommandBuffer, &m_ColorState);
    nvnCommandBufferBindDepthStencilState(pCommandBuffer, &m_DepthStencilState);
    nvnCommandBufferBindMultisampleState(pCommandBuffer, &m_MultisampleState);
    nvnCommandBufferBindPolygonState(pCommandBuffer, &m_PolygonState);
}
