﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{ShaderTypeEnum.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines some helper functions that give a more generic
 *  interface to the helper shader header files create by the offline asset
 *  file generating tool.
 */

#pragma once

#include <cstdint>
#include <string>

#include "ShaderHeaders/SimpleTexturedModelDataHelper.h"
#include "ShaderHeaders/CubemapDataHelper.h"
#include "ShaderHeaders/FontShaderDataHelper.h"
namespace ShaderTypes
{
    enum ShaderType
    {
        ShaderType_SimpleTexturedModel = 0,
        ShaderType_CubeMap = 1,
        ShaderType_FontShader = 2,
        ShaderType_Num,
    };

    ShaderType  GetShaderTypeEnum(const std::string& name);
    int32_t     Attributes_GetAttributeLocation(const std::string& name, ShaderType shaderType);
    uint32_t    Attributes_GetNumAttributes(ShaderType shaderType);
    uint8_t     Attributes_GetStagesReferencedIn(const std::string& name, ShaderType shaderType);

    uint32_t    BlockFS_GetBinding(uint32_t shaderStage, ShaderType shaderType);
    uint8_t     BlockFS_GetStagesReferencedIn(ShaderType shaderType);
    uint32_t    BlockFS_GetUniformBlockSize(ShaderType shaderType);

    void        BlockFS_SetUniform_u_bindlessTex(void* block, const uint64_t& uniformData, ShaderType shaderType);

    uint32_t    BlockVS_GetBinding(uint32_t shaderStage, ShaderType shaderType);
    uint8_t     BlockVS_GetStagesReferencedIn(ShaderType shaderType);
    uint32_t    BlockVS_GetUniformBlockSize(ShaderType shaderType);

    void        BlockVS_SetUniform_u_modelMtx(void* block, const float (&uniformData)[16], ShaderType shaderType);  // Model only
    void        BlockVS_SetUniform_u_projMtx(void* block, const float (&uniformData)[16], ShaderType shaderType);   // Model only
    void        BlockVS_SetUniform_u_viewMtx(void* block, const float (&uniformData)[16], ShaderType shaderType);   // Model only

    void        BlockVS_SetUniform_u_scale(void* block, const float (&uniformData)[2], ShaderType shaderType);      // Font only

    typedef  int32_t (*ShaderFunction)(const std::string&);
    ShaderFunction Attributes_GetAttributeLocationFunction(ShaderType shaderType);
}
