﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @examplesource{GraphicsObjectCube.h,PageSampleNvnTutorialLibrary}
 *
 * @brief
 *  This file defines a class that derives from the base
 *  GraphicsObject class for drawing the graphicsObjectCube.out
 *  asset file.
 */

#pragma once

#include "GraphicsObject.h"
#include <nn/util/util_Matrix.h>

class UniformBufferManager;
class ManagedUniformBuffer;

class GraphicsObjectCube : public GraphicsObject
{
    public:
        enum StateType
        {
            StateType_Opaque = 0,
            StateType_Wire   = 1
        };

        GraphicsObjectCube();
        virtual ~GraphicsObjectCube() ;

        virtual void SetScale(float x, float y, float z) ;
        virtual void SetTranslate(float x, float y, float z) ;
        virtual void SetRotate(float x, float y, float z) ;
        virtual void SetWorldMatrix(const nn::util::Matrix4x4fType& world) ;
        virtual void SetCameraMatrix(const nn::util::Matrix4x4fType& camera) ;
        virtual void SetProjectionMatrix(const nn::util::Matrix4x4fType& projection) ;

        virtual void Init(StateType type, AssetFileDataHolder* pData) ;
        virtual void SetupUniforms(UniformBufferManager* pUniformBufferManager);
        virtual void UpdateUniforms() ;
        virtual void Draw(NVNcommandBuffer* pCommandBuffer) const ;

    private:
        virtual void SetWireState() ;
        virtual void SetOpaqueState() ;

        ManagedUniformBuffer*       m_pUniformBlockVS;

        nn::util::Matrix4x4fType    m_WorldMatrix;

        float                       m_TranslateX;
        float                       m_TranslateY;
        float                       m_TranslateZ;

        float                       m_ScaleX;
        float                       m_ScaleY;
        float                       m_ScaleZ;

        float                       m_RotateX;
        float                       m_RotateY;
        float                       m_RotateZ;

        nn::util::Matrix4x4fType    m_CameraMatrix;
        nn::util::Matrix4x4fType    m_ProjectionMatrix;
};
