﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#if !defined(NNT_GFX_UTIL_ENABLE_LOP)
#error cannot include this file unsless NNT_GFX_UTIL_ENABLE_LOP is defined
#endif

namespace nnt { namespace gfx {  namespace util {
class ResourceAllocator;
} } } // namespace nnt { namespace gfx {  namespace util {


namespace profiler {

struct ProfilerState;

class ProfilerOptions
{
public:
    void        SetDefaults();
};

enum ProfilerUpdateResult
{
    ProfilerUpdateResult_Error,
    ProfilerUpdateResult_NewResultReady,
    ProfilerUpdateResult_MorePassRequired,
};

struct SectionResult
{
    int rangeNameArrayOffset;
    int rangeNameCount;
    int resultArrayOffset;
    int resultCount;
};

struct ProfilerResult
{
    static const int sectionResultArrayMaxCount = 4;
    SectionResult sectionResultArray[sectionResultArrayMaxCount];
    int activeSectionResultCount = 0;

    static const int metricResultArrayMaxCount = 1024;
    double metricResultArray[metricResultArrayMaxCount];
    int metricResultArrayActiveCount = 0;
};

void InitializeLopLibrary();

void PopProfilerDebugGroup(nn::gfx::CommandBuffer* pCommandBuffer);
void PushProfilerDebugGroup(nn::gfx::CommandBuffer* pCommandBuffer, const char* groupName);

class Profiler
{
    ProfilerState* m_pState;

public:
    bool Initialize(
        nn::gfx::Device* pDevice, nn::gfx::Queue* pQueue,
        nnt::gfx::util::ResourceAllocator* pResourceAllocator,
        const ProfilerOptions& profilerOptions);

    void Finalize();

    void BeginPass(nn::gfx::Queue* pQueue);
    void EndPass(nn::gfx::Queue* pQueue);

    void ResetCounterValues();

    ProfilerUpdateResult Update(ProfilerResult* ProfilerResult);

    int GetMetricCount() const;
    const char* GetMetricName(int metricIndex) const;
};



} // namespace profiler
