﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Log.h>

#include "testGfxUtil_Application.h"

#include "gfxUtilGpuBenchmark_JsonStreamer.h"
#include "gfxUtilGpuBenchmark_Factory.h"
#include "gfxUtilGpuBenchmark_PlatformId.h"

namespace {


} // anonymous namespace

void DoReplayDrawFrame(
    ApplicationTestData* pTestData,
    nnt::gfx::util::GpuBenchmark* pGpuBenchmark,
    int repeatCount)
{
    pTestData->debugFontWriter.SetCursor(0.0f, 0.0f);
    pTestData->debugFontWriter.SetScale(1.0f, 1.0f);

    pTestData->debugFontWriter.Print("Benchmark RepeatCount: %d\n", repeatCount);
    PrintBenchmarkInformation(
        &pTestData->debugFontWriter, pGpuBenchmark,
        g_DisableDrawSelection);

    DrawFrame(pTestData, pGpuBenchmark);
}

void DoReplayMode(
    ApplicationTestData* pTestData,
    const char* inputFilePath)
{
    if (!TestFilePathMountPointExist(inputFilePath))
    {
        NN_LOG("Cannot access file mount point: %s\n", inputFilePath);
        return;
    }

    nnt::gfx::util::json::Document* pJsonDocument = nullptr;

    nnt::gfx::util::json::Create(&pJsonDocument, nullptr);
    nn::Result result = nnt::gfx::util::json::LoadFromFile(pJsonDocument, inputFilePath);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    nnt::gfx::util::json::TestCaseIterator* testCaseIterator = nullptr;
    const int platformIdBufferSize = 128;
    char platformIdBuffer[platformIdBufferSize];
    nnt::gfx::util::GetPlatformId(platformIdBuffer, platformIdBufferSize);

    const char* filter = platformIdBuffer;

    nnt::gfx::util::json::InitializeTestIterator(&testCaseIterator, pJsonDocument);

    while (nnt::gfx::util::json::MoveToNextTestCase(filter, testCaseIterator))
    {
        ValidateTestCaseData(pTestData, testCaseIterator);
    }

    nnt::gfx::util::json::FinalizeTestIterator(testCaseIterator);
    nnt::gfx::util::json::Finalize(pJsonDocument);
}


