﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

namespace nnt { namespace gfx { namespace util {  namespace json {


struct Document;
struct TestCaseIterator;

typedef void* AllocFunc(size_t size);
typedef void* ReallocFunc(void* originalPtr, size_t originalSize, size_t newSize);
typedef void FreeFunc(void* ptr);

struct AllocatorCallbacks
{
    AllocFunc*       pAllocFunc;
    ReallocFunc*     pReallocFunc;
    FreeFunc*        pFreeFunc;
};

struct BenchmarkTestResult
{
    uint64_t cpuTimeAverage;
    uint64_t gpuTimeAverage;
    uint64_t cpuTimeStandardDeviation;
    uint64_t gpuTimeStandardDeviation;
};


void Create(Document** ppDocument, AllocatorCallbacks* pAllocator);
void Finalize(Document* pDocument);

nn::Result LoadFromFile(Document* pDocument, const char* filepath);
nn::Result SaveToFile(const Document* pDocument, const char* filepath);

int GetDocumentVersion(Document* pDocument);

void InitializeTestIterator(TestCaseIterator** ppOutIterator, Document* pDocument);
void FinalizeTestIterator(TestCaseIterator* pIterator);
void CopyTestIterator(TestCaseIterator** ppOutIterator, TestCaseIterator* pSourceIterator);
bool HasMoreTestCase(const char* filter, const TestCaseIterator* pIterator);
bool MoveToNextTestCase(const char* filter, TestCaseIterator* pIterator);

const char* GetTestCaseName(const TestCaseIterator* pTestCase);
const char* GetTestCaseId(const TestCaseIterator* pTestCase);
int GetTestCaseWarmUpCount(const TestCaseIterator* pIterator);
int GetTestCaseRepeatCount(const TestCaseIterator* pIterator);
int GetTestCaseOutputBufferHash(const TestCaseIterator* pIterator, void* pOutputBufferHash, int outputBufferHashSize);
void GetTestCaseExpectedResult(const TestCaseIterator* pTestCase, BenchmarkTestResult* pBenchmarkTestResult);
void ApplyTestCaseConfiguration(const TestCaseIterator* pTestCase, GpuBenchmark* pBenchmark);

bool HasTestWithId(Document* pDocument, const char* uniqueTestId);
void CreateOrUpdateBenchmarkTestCase(
    Document* pDocument,
    const GpuBenchmark* pBenchmark,
    const BenchmarkTestResult* pBenchmarkTestResult,
    const void* pOutputBufferHash, int outputBufferHashSize,
    int warmUpCount, int repeatCount,
    const char* uniqueTestId);

} } } } // namespace json { namespace nnt { namespace gfx { namespace util {
