﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

#include "gfxUtilGpuBenchmark_Property.h"
#include "gfxUtilGpuBenchmark_PropertyArray.h"
#include "gfxUtilGpuBenchmark_ResShader.h"


#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_State.h>
#include <nn/gfx/gfx_Buffer.h>
#include <nn/gfx/gfx_DescriptorSlot.h>

//#define NN_GFXUTIL_GPUBENCHMARK_FILLRATE_DEBUG

namespace nnt { namespace gfx { namespace util {

class GpuBenchmarkFillrate : public GpuBenchmark
{
public:
    enum PrimitiveType
    {
        PrimitiveType_Quad,
        PrimitiveType_Triangle,
    };

    static const char* ClassName;

private:
    int                             m_RenderSize;
    nn::gfx::ImageFormat            m_RenderFormat;
    nn::gfx::TileMode               m_TileMode;
    PrimitiveType                   m_PrimitiveType;
    nn::gfx::ImageFormat            m_DepthBufferFormat;


    nn::gfx::Texture                m_RenderTexture;
    nn::gfx::Texture                m_DepthStencilTexture;

    nn::gfx::ColorTargetView        m_RenderTextureTargetView;
    nn::gfx::DepthStencilView       m_DepthStencilView;
    nn::gfx::ViewportScissorState   m_RenderTextureViewportScissorState;

    nn::gfx::Buffer                 m_VertexBuffer;
    size_t                          m_VertexBufferSize;

    ResShader                       m_ResShader;

    nn::gfx::DepthStencilState      m_DepthStencilState;

    nn::gfx::Buffer                     m_OutputCopyBuffer;
    size_t                              m_OutputCopyBufferSize;

#if defined(NN_GFXUTIL_GPUBENCHMARK_FILLRATE_DEBUG)
    nn::gfx::TextureView            m_RenderTextureView;
    int                             m_RenderTextureViewDescriptorSlotIndex;
    nn::gfx::DescriptorSlot         m_RenderTextureViewDescriptorSlot;

    nn::gfx::TextureView            m_DepthStencilTextureView;
    int                             m_DepthStencilTextureViewDescriptorSlotIndex;
    nn::gfx::DescriptorSlot         m_DepthStencilTextureViewDescriptorSlot;

    nn::gfx::Sampler                m_DebugTextureSampler;
    int                             m_DebugTextureSamplerDescriptorSlotIndex;
    nn::gfx::DescriptorSlot         m_DebugTextureSamplerDescriptorSlot;

#endif

    enum Property
    {
        Property_RenderSize,
        Property_RenderFormat,
        Property_TileMode,
        Property_PrimitiveType,
        Property_DepthBufferFormat,
        Property_Count,
    };


    PropertyArray<Property_Count>   m_PropertyArray;


public:
                                                GpuBenchmarkFillrate();
    virtual                                     ~GpuBenchmarkFillrate();

    virtual void                                Initialize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;
    virtual void                                Finalize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;

    virtual void                                InitializeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;
    virtual void                                FinalizeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;

    int                                         GetRenderSize() const;
    void                                        SetRenderSize(int width);

    nn::gfx::ImageFormat                        GetRenderFormat() const;
    void                                        SetRenderFormat(nn::gfx::ImageFormat format);

    nn::gfx::TileMode                           GetTileMode() const;
    void                                        SetTileMode(nn::gfx::TileMode mode);

    PrimitiveType                               GetPrimitiveType() const;
    void                                        SetPrimitiveType(PrimitiveType type);

    nn::gfx::ImageFormat                        GetDepthBufferFormat() const;
    void                                        SetDepthBufferFormat(nn::gfx::ImageFormat mode);

    virtual void                                PreBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;
    virtual void                                DoBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer, int runCount) NN_OVERRIDE;
    virtual void                                RenderDebug(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;

    virtual void                                PrintResults(nn::TimeSpan cpuTimeElapsed, nn::TimeSpan gpuTimeElapsed, int runCount, nn::gfx::util::DebugFontTextWriter* pDebugFontTextWriter) NN_OVERRIDE;

    virtual void                                CopyResultToBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_OVERRIDE;
    virtual void                                MapResultBuffer(void** pOutBuffer, size_t* pOutBufferSize) NN_OVERRIDE;
    virtual void                                UnmapResultBuffer() NN_OVERRIDE;

    virtual const char*                         GetName() const NN_OVERRIDE;
    virtual BenchmarkType                       GetType() const NN_OVERRIDE;
    virtual int                                 GetPropertyCount() const NN_OVERRIDE;
    virtual int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const NN_OVERRIDE;
    virtual int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         GetPropertyByIndex(int index) NN_OVERRIDE;

private:
    void                                        InitializeGfxObjectsRender(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
};


inline int GpuBenchmarkFillrate::GetRenderSize() const
{
    return m_RenderSize;
}

inline void GpuBenchmarkFillrate::SetRenderSize(int width)
{
    m_RenderSize = width;
}

inline nn::gfx::ImageFormat GpuBenchmarkFillrate::GetRenderFormat() const
{
    return m_RenderFormat;
}

inline void GpuBenchmarkFillrate::SetRenderFormat(nn::gfx::ImageFormat format)
{
    m_RenderFormat = format;
}

inline nn::gfx::TileMode GpuBenchmarkFillrate::GetTileMode() const
{
    return m_TileMode;
}

inline void GpuBenchmarkFillrate::SetTileMode(nn::gfx::TileMode mode)
{
    m_TileMode = mode;
}

inline GpuBenchmarkFillrate::PrimitiveType GpuBenchmarkFillrate::GetPrimitiveType() const
{
    return m_PrimitiveType;
}

inline void GpuBenchmarkFillrate::SetPrimitiveType(PrimitiveType type)
{
    m_PrimitiveType = type;
}

inline nn::gfx::ImageFormat GpuBenchmarkFillrate::GetDepthBufferFormat() const
{
    return m_DepthBufferFormat;
}

inline void GpuBenchmarkFillrate::SetDepthBufferFormat(nn::gfx::ImageFormat format)
{
    NN_ASSERT(
        (format == nn::gfx::ImageFormat_Undefined)
        || (format == nn::gfx::ImageFormat_D24_Unorm_S8_Uint)
        || (format == nn::gfx::ImageFormat_D32_Float));

    m_DepthBufferFormat = format;
}

} } } // namespace nnt { namespace gfx { namespace util {
