﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <stdint.h>
#include <cstddef>

namespace nnt { namespace gfx { namespace util { namespace agingtest {

struct BmpFileInfo
{
    int         width;
    int         height;
    ptrdiff_t   stride;
    int         bpp;
    int         swizzle;
};

struct BmpInputStream
{
    const uint8_t*          pBuffer;
    size_t                  bufferSize;
    size_t                  readOffset;
};

bool ReadBmpFileInfoFromStream(const BmpInputStream* pIs, BmpFileInfo* pBmpFileInfo);
bool ReadBmpFromStream(BmpInputStream* pIs, const BmpFileInfo* pBmpFileInfo, void* pPixelOutBuffer, size_t pixelOutBufferSizeInBytes);

} } } } // namespace nnt { namespace gfx { namespace util { namespace agingtest {
