﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfx/demo.h>

namespace LegacyGPGPUShallowWater {

enum Sampler
{
    POINT,
    LINEAR
};

//
// Buffer for input data
//
struct Texture2D
{
    nn::gfx::Texture        textureBuffer;
    nn::gfx::TextureInfo    textureInfo;
    nn::gfx::TextureView    textureView;
    nn::gfx::DescriptorSlot textureSlot;
    nn::gfx::DescriptorSlot* pSamplerSlot;
    u32                     width;
    u32                     height;
    nn::gfx::MemoryPool     memoryPool;
    void*                   imagePtr;
};

//
// Buffer for I/O data
//
struct RenderTarget
{
    nn::gfx::ColorTargetView    colorBuffer;
    nn::gfx::Texture            textureBuffer;
    nn::gfx::TextureInfo        textureInfo;
    nn::gfx::TextureView        textureView;
    nn::gfx::DescriptorSlot     textureSlot;
    nn::gfx::DescriptorSlot*    pSamplerSlot;
    DEMOGfxMemPool*             imagePtr;
    u32 width;
    u32 height;
};

struct Pass
{
    DEMOGfxPipeline pipeline;

    // -- Vertex Fetch Info -- //
    nn::gfx::VertexAttributeStateInfo attribs[2];

    // -- Texture Setting -- //
    u32 myColorBufferWidth;
    u32 myColorBufferHeight;
    nn::gfx::DepthStencilView myDepthBufferView;
    nn::gfx::Texture          myDepthBufferTexture;
    DEMOGfxMemPool* pDepthBufferData;

    // other state
    nn::gfx::ViewportScissorState viewportScissor;
    void* viewportMem;
};

void Init();
void Free();

void InitTexture2D( Texture2D& texture, u32 w, u32 h,
    nn::gfx::ImageFormat format, Sampler sampler, void* pinitvalues );
void FreeTexture2D( Texture2D& texture );
void InvalidateRenderTarget( nn::gfx::CommandBuffer* cmd, RenderTarget& renderTarget );
void InitRenderTarget( RenderTarget& renderTarget, u32 w, u32 h,
    nn::gfx::ImageFormat format, Sampler sampler );
void FreeRenderTarget( RenderTarget& renderTarget );

void SetInputUniform( Pass& pass, DEMOGfxBuffer& uniformView, const char* uniform_name );
void SetInputRenderTarget( Pass& pass, RenderTarget& texture, const char* texture_name );
void SetInputTexture2D( Pass& pass, Texture2D& texture, const char* texture_name );
void SetInputTextureSampler( Pass& pass, nn::gfx::DescriptorSlot& pTextureSlot, nn::gfx::DescriptorSlot& pSamplerSlot,
    const char* texture_name );
void ComputePass( Pass& pass, RenderTarget* renderTarget[], u32 renderTargetNum );
void InitPipeline( Pass& pass, int numRenderTargets, nn::gfx::ImageFormat* formats );
void InitPass( Pass& pass, const char* shader_paths,
    const u32 domain_width, const u32 domain_height,
    const u32 numRenderTargets, nn::gfx::ImageFormat* imageFormats );
void FreePass( Pass& pass );
#if NN_GFX_IS_TARGET_D3D
void ResetRenderTarget();
#endif
};
