﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////===========================================================================
///  demoPad.c
///
///     This is a pad code for the demo library.
///
////===========================================================================

#include <gfx/demo.h>
#include <nn/hid.h>

// -------------------------------------------------------------------------
//  Global Values
// -------------------------------------------------------------------------
// Demo Pad Status
DemoPadStatus  g_DemoPad[ DEMO_PAD_MAX_CONTROLLERS ];


// ------------------------------------------------------------------------
//  Macro definitions
// ------------------------------------------------------------------------
#define padButtonDown(buttonLast, button)   \
    ((u16) (((buttonLast) ^ (button)) & (button)))

#define padButtonUp(buttonLast, button)     \
    ((u16) (((buttonLast) ^ (button)) & (buttonLast)))

// -------------------------------------------------------------------------
//  Internal Fuctions
// -------------------------------------------------------------------------
// Attaches informations such as down/up, stick direction.

#if 0 // FIXME
static const unsigned int BUTTON_IS_DOWN = 0x8000;

static u16 SetButtonDown ( u16 button, int mask, u16 keyState )
{

    if ( (keyState & BUTTON_IS_DOWN) != 0)
    {
        button |= mask;
    }
    else
    {
        button &= ~mask;
    }
    return button;
}
#endif

// -------------------------------------------------------------------------
//  Initialize
// -------------------------------------------------------------------------
void DEMOPadInit()
{
    u32 i;

    nn::hid::InitializeDebugPad();

    // Reset exported pad status
    for (i = 0 ; i < DEMO_PAD_MAX_CONTROLLERS ; i++)
    {
        g_DemoPad[i].button = 0;
        g_DemoPad[i].stickX = 0;
        g_DemoPad[i].stickY = 0;
        g_DemoPad[i].substickX = 0;
        g_DemoPad[i].substickY = 0;
        g_DemoPad[i].triggerLeft = 0;
        g_DemoPad[i].triggerRight = 0;
        g_DemoPad[i].analogA = 0;
        g_DemoPad[i].analogB = 0;
        g_DemoPad[i].err = 0;
        g_DemoPad[i].lastButton = 0;
        g_DemoPad[i].buttonDown = 0;
        g_DemoPad[i].buttonUp = 0;
        g_DemoPad[i].dirs = 0;
        g_DemoPad[i].dirsNew = 0;
        g_DemoPad[i].dirsReleased = 0;
        g_DemoPad[i].stickDeltaX = 0;
        g_DemoPad[i].stickDeltaY = 0;
        g_DemoPad[i].substickDeltaX = 0;
        g_DemoPad[i].substickDeltaY = 0;
    }
}

// -------------------------------------------------------------------------
//  ShutDown
// -------------------------------------------------------------------------
void DEMOPadShutdown()
{
    u32 i;
    // Reset exported pad status
    for (i = 0 ; i < DEMO_PAD_MAX_CONTROLLERS ; i++)
    {
        g_DemoPad[i].button = 0;
        g_DemoPad[i].stickX = 0;
        g_DemoPad[i].stickY = 0;
        g_DemoPad[i].substickX = 0;
        g_DemoPad[i].substickY = 0;
        g_DemoPad[i].triggerLeft = 0;
        g_DemoPad[i].triggerRight = 0;
        g_DemoPad[i].analogA = 0;
        g_DemoPad[i].analogB = 0;
        g_DemoPad[i].err = 0;
        g_DemoPad[i].lastButton = 0;
        g_DemoPad[i].buttonDown = 0;
        g_DemoPad[i].buttonUp = 0;
        g_DemoPad[i].dirs = 0;
        g_DemoPad[i].dirsNew = 0;
        g_DemoPad[i].dirsReleased = 0;
        g_DemoPad[i].stickDeltaX = 0;
        g_DemoPad[i].stickDeltaY = 0;
        g_DemoPad[i].substickDeltaX = 0;
        g_DemoPad[i].substickDeltaY = 0;
    }
}

// -------------------------------------------------------------------------
//  Read
// -------------------------------------------------------------------------
static const int STICK_SCALE = 9;

u32 DEMOPadRead ()
{
    nn::hid::DebugPadState state;
    nn::hid::GetDebugPadState(&state);
    u16 buttons = g_DemoPad[0].button;
    u16 lastButtons = buttons;
    s16 newStickLX, newStickLY;
    s16 newStickRX, newStickRY;

    g_DemoPad[0].lastButton = lastButtons;
    buttons = 0;
    {
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::Left>() ? DEMO_PAD_BUTTON_LEFT : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::Up>() ? DEMO_PAD_BUTTON_UP : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::Right>() ? DEMO_PAD_BUTTON_RIGHT : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::Down>() ? DEMO_PAD_BUTTON_DOWN : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::A>() ? DEMO_PAD_BUTTON_A : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::B>() ? DEMO_PAD_BUTTON_B : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::X>() ? DEMO_PAD_BUTTON_X : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::Y>() ? DEMO_PAD_BUTTON_Y : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::R>() ? DEMO_PAD_TRIGGER_R : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::L>() ? DEMO_PAD_TRIGGER_L : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::ZL>() ? DEMO_PAD_TRIGGER_Z : 0;
        buttons |= state.buttons.Test<nn::hid::DebugPadButton::ZR>() ? DEMO_PAD_TRIGGER_Z : 0;
    }
    g_DemoPad[0].button = buttons;
    g_DemoPad[0].buttonDown = padButtonDown(lastButtons, buttons);
    g_DemoPad[0].buttonUp = padButtonUp(lastButtons, buttons);

    newStickLX = ((s16)state.analogStickL.x) >> STICK_SCALE;
    newStickLY = ((s16)state.analogStickL.y) >> STICK_SCALE;
    newStickRX = ((s16)state.analogStickR.x) >> STICK_SCALE;
    newStickRY = ((s16)state.analogStickR.y) >> STICK_SCALE;
    g_DemoPad[0].stickDeltaX = newStickLX - g_DemoPad[0].stickX;
    g_DemoPad[0].stickDeltaY = newStickLY - g_DemoPad[0].stickY;
    g_DemoPad[0].substickDeltaX = newStickRX - g_DemoPad[0].substickX;
    g_DemoPad[0].substickDeltaY = newStickRY - g_DemoPad[0].substickY;

    g_DemoPad[0].stickX = newStickLX;
    g_DemoPad[0].stickY = newStickLY;
    g_DemoPad[0].substickX = newStickRX;
    g_DemoPad[0].substickY = newStickRY;

    return TRUE;
}

