﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// -----------------------------------------------------------------------------
//  demoCommon.h
//
// -----------------------------------------------------------------------------

#pragma once

#include <cstring>

#include <types.h>
#include <private/fsa.h>
#include <cafe/os.h>
#include <cafe/mem.h>
#include <cafe/pad.h>


/// @addtogroup demoCommon
/// @{

// These types should be defined by SDK

#define DEMO_INLINE static inline

#define DEMOAssert(expr) ASSERT(expr)
#define DEMORoundUp256B(x) (((u32)(x) + 256 - 1) & ~(256 - 1))
#define DEMORoundUp32B(x) (((u32)(x) + 32 - 1) & ~(32 - 1))
#define DEMORoundUp4B(x) (((u32)(x) + 4 - 1) & ~(4 - 1))

#define DEMORoundUpForIO(x) (((u32)(x) + PPC_IO_BUFFER_ALIGN - 1) & ~(PPC_IO_BUFFER_ALIGN - 1))

/// @}
