﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// -----------------------------------------------------------------------------
// standard header here
// -----------------------------------------------------------------------------

#pragma once

#define NN_PERF_PROFILE_ENABLED

#include <nn/gfx/gfx_Config.h>
#if NN_GFX_CONFIG_TARGET_API == NN_GFX_CONFIG_API_D3D11
#undef NN_PERF_PROFILE_ENABLED  // TODO: perf library depends on gfx, currently perf doesn't support d3d.
#endif

#include <nn/gfx.h>
#include <nn/perf.h>

#include <cstring>
#include <cstdlib>

#ifdef CAFE
#include <types.h>
#else
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <cstdint>
#include <ctime>

typedef int8_t s8;
typedef uint8_t u8;
typedef int16_t s16;
typedef uint16_t u16;
typedef int32_t s32;
typedef uint32_t u32;
typedef int64_t s64;
typedef uint64_t u64;
typedef float f32;

typedef int BOOL;
#ifndef TRUE
enum BoolValues { FALSE = 0, TRUE = 1 };
#endif

#if defined( NN_BUILD_CONFIG_OS_SUPPORTS_HORIZON )
#include <nn/nn_Log.h>
#define OSReport NN_LOG
#else
#define OSReport printf
#endif
#define OSMemoryBarrier()
#define GX2_INLINE inline

typedef u64 OSTime;
u64 OSGetTime();
u64 OSTicksToMilliseconds( u64 x );
u64 OSTicksToMicroseconds( u64 x );

static const int PPC_IO_BUFFER_ALIGN = 4096;

#endif

#include <gfx/demo_AvxCafe.h>
#include <gfx/demo_System.h>
#include <gfx/demo_PadCafe.h>
#include <gfx/demo_Fs.h>
#include <gfx/demo_FwbCafe.h>
#include <gfx/demo_Test.h>
#include <gfx/demo_Gfx.h>
#include <gfx/demo_Gfd.h>
#include <gfx/demo_Font.h>
#include <gfx/demo_Capture.h>
#include <gfx/demo_Mat.h>
#include <gfx/demo_Mtx.h>
#include <gfx/demo_Perf.h>


/// @defgroup demo Demo

/// @defgroup demoSystem Demo Base System
/// @ingroup demo

/// @defgroup demoFileSystem Demo File System
/// @ingroup demo

/// @defgroup demoFileWriteBuffer Demo File Write Buffer
/// @ingroup demo

/// @defgroup demoPad Demo Pad
/// @ingroup demo

/// @defgroup demoTest Demo Test
/// @ingroup demo

/// @defgroup demoGfx Demo Graphics
/// @ingroup demo

/// @defgroup demoRender Demo Render
/// @ingroup demoGfx

/// @defgroup demoShader Demo Shader
/// @ingroup demoGfx

/// @defgroup demoGfd Demo Gfd
/// @ingroup demoGfx

/// @defgroup demoFont Demo Font
/// @ingroup demoGfx

/// @defgroup demoCapture Demo Frame Capture
/// @ingroup demoGfx

/// @defgroup demoDRC Demo DRC
/// @ingroup demoGfx

/// @defgroup demoDRCCamera Demo DRC Camera
/// @ingroup demoGfx

/// @defgroup demoGfxTypes Demo Graphics Types
/// @ingroup demoGfx

/// @defgroup demoCommon Demo Common
/// @ingroup demo

#ifdef WIN32
// determine if any of this applications windows has focus
bool DEMO_HasFocus();
#endif
