﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/gfx/gfx_Types.h>
#include <nn/g3d/viewer/g3d_ViewerCallbackUtility.h>

namespace G3dTest{

    //! @brief テスト関数に入った際と抜ける際に何か行いたい処理を書きます。
    class TestFuncPrePostProcessHandler
    {
    public:
        explicit TestFuncPrePostProcessHandler(const char* funcName) NN_NOEXCEPT
            : m_FuncName(funcName)
        {
            NN_LOG("Entered %s\n", m_FuncName);
        }

        ~TestFuncPrePostProcessHandler() NN_NOEXCEPT
        {
            NN_LOG("Exited %s\n", m_FuncName);
        }

    private:
        const char* m_FuncName;
    };

    class ViewerTestCallback : public nn::g3d::viewer::ViewerCallbacks
    {
    };

    nn::gfx::Device* GetDevice() NN_NOEXCEPT;
}
