﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testG3d_ScopedMemoryLeakDetector.h"
#include "testG3d_ViewerTestAllocator.h"
#include "testG3d_FileIoUtility.h"
#include "testG3d_ViewerTestUtility.h"

#include "nnt/g3d/testG3d_TestUtility.h"

#include <model/g3d_EditSkeletonObj.h>
#include <model/g3d_EditModelObj.h>
#include <nn/g3d/viewer/g3d_ViewerServer.h>
#include <nn/g3d/viewer/g3d_ViewerCallbackUtility.h>

#include <nn/g3d/g3d_ModelObj.h>
#include <nn/g3d/g3d_ResFile.h>

#include <nn/gfx/gfx_ResTexture.h>

#include <nn/htcs.h>
#include <nn/gfx/gfx_Device.h>
#include <nn/fs.h>

#include <nnt/nntest.h>

using namespace nn::g3d;
using namespace nn::g3d::viewer;
using namespace nn::g3d::viewer::detail;
using namespace G3dTest;

const char* g_HumaBfresPath = "Resource:/human.bfres";

TEST(G3dViewerEditObjTest, EditObjTest)
{
    TestFuncPrePostProcessHandler prePostProcessHandler(__FUNCTION__);
    G3dTest::ScopedMemoryLeakDetector memoryLeakDetector;
    nn::gfx::MemoryPool memoryPool;
    void* blockBuffer;
    bool success;

    G3dTest::ViewerTestAllocator allocator;
    nn::g3d::viewer::detail::Allocator detailAllocator(
        G3dTest::ViewerTestAllocator::AllocateWithUserData,
        G3dTest::ViewerTestAllocator::FreeWithUserData,
        &allocator, &allocator);

    ResFile* pResFile = LoadResFile(g_HumaBfresPath, *GetDevice(), allocator);
    EXPECT_TRUE(pResFile->GetModelCount() > 0);

    ModelObj modelObj;
    ResModel* pResModel = pResFile->GetModel(0);
    {
        ModelObj::Builder builder(pResModel);
        builder.CalculateMemorySize();
        size_t memorySize = builder.GetWorkMemorySize();
        void* buffer = allocator.Allocate(memorySize, 256);
        builder.Build(&modelObj, buffer, memorySize);

        size_t blockBufferSize = modelObj.CalculateBlockBufferSize(GetDevice());
        blockBuffer = allocator.Allocate(blockBufferSize, 256);
        nn::gfx::MemoryPool::InfoType memoryPoolInfo;
        memoryPoolInfo.SetDefault();
        memoryPoolInfo.SetPoolMemory(blockBuffer, blockBufferSize);
        memoryPool.Initialize(GetDevice(), memoryPoolInfo);
        success = modelObj.SetupBlockBuffer(GetDevice(), &memoryPool, 0, blockBufferSize);
        EXPECT_TRUE(success);
    }

    // EditSkeletonObj のテスト
    {
        nn::g3d::viewer::detail::EditSkeletonObj editSkeletonObj(&modelObj, modelObj.GetSkeleton(), GetDevice(), &detailAllocator);

        // WorkBlock 用のメモリプールを作成
        nn::gfx::MemoryPool memoryPoolForSkeleton;
        size_t blockBufferSize = editSkeletonObj.CalculateBlockBufferSize(pResModel->GetSkeleton());
        size_t blockBufferAlignment = editSkeletonObj.GetBlockBufferAlignment(pResModel->GetSkeleton());
        nn::gfx::MemoryPool::InfoType memoryPoolInfo;
        memoryPoolInfo.SetDefault();
        size_t memoryPoolAlignment = nn::gfx::MemoryPool::GetPoolMemoryAlignment(GetDevice(), memoryPoolInfo);
        size_t memoryPoolSizeAlignment = nn::gfx::MemoryPool::GetPoolMemorySizeGranularity(GetDevice(), memoryPoolInfo);
        size_t memoryPoolBufferSize = nn::util::align_up<size_t>(blockBufferSize, memoryPoolSizeAlignment);
        size_t memoryPoolBufferAlignment = nn::util::align_up<size_t>(blockBufferAlignment, memoryPoolAlignment);
        void* blockBufferForSkeleton = allocator.Allocate(memoryPoolBufferSize, memoryPoolBufferAlignment);
        memoryPoolInfo.SetPoolMemory(blockBufferForSkeleton, memoryPoolBufferSize);
        memoryPoolForSkeleton.Initialize(GetDevice(), memoryPoolInfo);

        editSkeletonObj.ResetToOriginal();
        editSkeletonObj.SetupSkeletonInstance(pResModel->GetSkeleton(), &memoryPoolForSkeleton, 0, blockBufferSize);
        editSkeletonObj.ResetToOriginal();
        editSkeletonObj.ClearBuffers();

        memoryPoolForSkeleton.Finalize(GetDevice());
        allocator.Free(blockBufferForSkeleton);
    }

    modelObj.GetMemoryPoolPtr()->Finalize(GetDevice());
    allocator.Free(blockBuffer);
    allocator.Free(modelObj.GetBufferPtr());

    FreeFile(pResFile, allocator);
}
