﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/init.h>
#include <nn/os.h>
#include <nn/g3d.h>
#include <nn/time.h>
#include "SampleSources/g3ddemo_DemoUtility.h"
#include "SampleSources/g3ddemo_GfxUtility.h"
#include <nnt/graphics/testGraphics_GetHostExecutableFilepath.h>
#include <nnt/graphics/testGraphics_CreateDirectories.h>

extern int TownMain(bool isUseRankTurn);
extern int ParallelMain(bool isUseRankTurn);

extern "C" void nnMain()
{
    nn::os::Tick beginTick = nn::os::GetSystemTick();

    char** argv = nn::os::GetHostArgv();
    int argc = nn::os::GetHostArgc();

    nn::g3d::demo::Initialize();
    nn::g3d::demo::InitializeDemo();

    nn::time::Initialize();
    nn::Result result;
    nnt::graphics::Path outputsPath(nnt::graphics::GetHostExecutableFilepath());
    outputsPath.MakeParent();
    NN_LOG("Mount Outputs: %s\n", outputsPath.GetString());
    result = nn::fs::MountHost("Outputs", outputsPath.GetString());
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    result = nnt::graphics::CreateDirectories("Outputs:/Outputs");
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    nn::os::Tick endTick = nn::os::GetSystemTick();
    NN_LOG("InitialCost:%f(ms)\n", (endTick.ToTimeSpan().GetMicroSeconds() - beginTick.ToTimeSpan().GetMicroSeconds()) / 1000.f);

    // プログラム引数で以下を指定
    // ・どのシーンを実行するか(省略時はどちらも実行)
    // ・RankTurn の計測をするかどうか(省略時はfalse) true の場合は結果を出力しない&無限ループ
    bool isUseRankTurn = false;
    if (argc > 2)
    {
        if (!strcmp(argv[2], "true"))
        {
            isUseRankTurn = true;
            NN_LOG("@@@ RankTurn Enabled @@@\n");
        }
    }

    if (argc > 1)
    {
        char* scene = argv[1];
        if (!strcmp(scene, "Parallel"))
        {
            NN_LOG("@@@ Parallel @@@\n");
            ParallelMain(isUseRankTurn);
        }
        else if (!strcmp(scene, "Town"))
        {
            NN_LOG("@@@ Town @@@\n");
            TownMain(isUseRankTurn);
        }
        else
        {
            NN_LOG("@@@ Both @@@\n");
            ParallelMain(isUseRankTurn);
            TownMain(isUseRankTurn);
        }
    }
    else
    {
        NN_LOG("@ Both @\n");
        ParallelMain(isUseRankTurn);
        TownMain(isUseRankTurn);
    }

    nn::time::Finalize();
    nn::g3d::demo::FinalizeDemo();
    nn::g3d::demo::Finalize();

    return;
}
