﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nnt/g3d/testG3d_TestUtility.h>
#include "testG3d_MiiCharModelCreateArg.h"
#include "testG3d_MiiCharModel.h"

void MiiCharModel::Initialize( nn::gfx::Device* pDevice, const CharModelCreateArg* pCharModelCreateArg  )
{
    //void LoadCharInfor()
    {
        size_t size = 0;
        m_pCharInfo = reinterpret_cast<nn::mii::CharInfo*>( nnt::g3d::LoadFile( &size, pCharModelCreateArg->GetCharInfoPath(), 8 ) );
        NN_ASSERT( nn::mii::CharInfoAccessor( *m_pCharInfo ).IsValid() );
    }

    //void InitializeMiiResource()
    {
        // リソースロード
        size_t textureFileSize;
        m_pTextureResourceFile = nnt::g3d::LoadFile( &textureFileSize, pCharModelCreateArg->GetTexPath(), nn::mii::ResourceMemoryAlignment );
        size_t shapeFileSize;
        m_pShapeResourceFile = nnt::g3d::LoadFile( &shapeFileSize, pCharModelCreateArg->GetShapePath(), nn::mii::ResourceMemoryAlignment );

        // リソースを初期化する
        nn::mii::ResourceInfo info;
        info.SetDefault();
        info.SetGammaType(nn::mii::GammaType_Srgb);
        size_t alignment = nn::mii::Resource::CalculateMemoryAlignment( m_pTextureResourceFile, textureFileSize, m_pShapeResourceFile, shapeFileSize, info );
        size_t size = nn::mii::Resource::CalculateMemorySize( m_pTextureResourceFile, textureFileSize, m_pShapeResourceFile, shapeFileSize, info );
        void* pMemory = nnt::g3d::AlignedAllocate<void>( size, alignment );
        nn::Result result = m_Resource.Initialize( pMemory, size, m_pTextureResourceFile, textureFileSize, m_pShapeResourceFile, shapeFileSize, info, pDevice );
        NN_ASSERT(result.IsSuccess());
    }

    //void InitializeCharModel()
    {
        nn::mii::CharModelInfo info;
        info.SetDefault();
        info.SetDynamicTextureResolution( pCharModelCreateArg->GetTexResolution(), pCharModelCreateArg->GetTexResolution() );
        info.SetCreateFlag( pCharModelCreateArg->GetCreateFlags() );
        info.SetDynamicTextureFormat( pCharModelCreateArg->GetTexFormat(), pCharModelCreateArg->GetTexFormat() );
        info.SetMaskCount( nn::mii::GetExpressionCount( pCharModelCreateArg->GetExpressionFlags() ) );
        info.SetDynamicTextureMipCount( pCharModelCreateArg->GetTexMipCount(), pCharModelCreateArg->GetTexMipCount() );

        // メモリプール初期化
    #if 0
        size_t memoryPoolAlignment = nn::mii::CharModel::CalculateMemoryPoolAlignment( pDevice, m_Resource, info );
    #else
        size_t memoryPoolAlignment = 4 * 1024;
    #endif
    #if 0
        size_t memoryPoolSize = nn::mii::CharModel::CalculateMemoryPoolSize( pDevice, m_Resource, info );
    #else
        size_t memoryPoolSize = nn::util::align_up( nn::mii::CharModel::CalculateMemoryPoolSize( pDevice, m_Resource, info ), 4 * 1024 );
    #endif
        int offset = 0;
        void* pMemPool = nnt::g3d::AlignedAllocate( memoryPoolSize, memoryPoolAlignment );
        nn::gfx::MemoryPool::InfoType memPoolInfo;
        memPoolInfo.SetDefault();
        memPoolInfo.SetMemoryPoolProperty( nn::gfx::MemoryPoolProperty_CpuCached | nn::gfx::MemoryPoolProperty_GpuCached | nn::gfx::MemoryPoolProperty_Compressible );
        memPoolInfo.SetPoolMemory( pMemPool, memoryPoolSize );
        m_CharModelMemPool.Initialize( pDevice, memPoolInfo );

        // CharModel初期化
    #if 0
        size_t alignment = nn::mii::CharModel::CalculateMemoryAlignment( info );
    #else
        size_t alignment = 8;
    #endif
        size_t size = nn::mii::CharModel::CalculateMemorySize( info );
        void* pMemory = nnt::g3d::AlignedAllocate( size, alignment );
    #if 0
        size_t tempAlignment = nn::mii::CharModel::CalculateTemporaryBufferAlignment( m_Resource, info );
    #else
        size_t tempAlignment = 8;
    #endif
        size_t tempSize = nn::mii::CharModel::CalculateMemorySize( info );
        nn::mii::TemporaryBuffer* pTempMemory = nnt::g3d::AlignedAllocate<nn::mii::TemporaryBuffer>( tempSize, tempAlignment );
        nn::Result result = m_CharModel.Initialize( pMemory, size, pDevice,
                                                    &m_CharModelMemPool, offset, memoryPoolSize,
                                                    m_Resource, pTempMemory, info, *m_pCharInfo );
        NN_UNUSED( result );
    }
}

void MiiCharModel::Finalize( nn::gfx::Device* pDevice )
{
    m_Resource.Finalize( pDevice );
    m_CharModel.Finalize( pDevice );
    m_CharModelMemPool.Finalize( pDevice );
}
