@echo off
set PROJFILE=
set PLATFORM=
set CONFIGURATION=
set VS_VERSION=VS2013
set SPEC=%1
set OS=%2
set ADDRESS=%3
set BUILD_TARGET_NAME=%4
set BUILD_TYPE=%5
set TARGET=%6

if "%1" equ "" (
    rem ob`𒼐ڋNƂ̃ftHgl
    set SPEC=NX
    set OS=win32
    set ADDRESS=64
    set BUILD_TARGET_NAME=NX-x64-v140
    set BUILD_TYPE=Develop
)

set SIGLO_ROOT=%~dp0..\..\..\..\..\..\..
set G3DDEMO_ROOT=%SIGLO_ROOT%\Samples\Sources\Applications\G3dDemo
set G3DTOOLS=%SIGLO_ROOT%\Tools\Graphics\3dTools
set FILTER=%G3DTOOLS%\3dIntermediateFileFilter.exe
set ASSIGNUTIL=%G3DTOOLS%\3dIntermediateFileAssignUtility.exe
set CONTENT_DIR=%SIGLO_ROOT%\Tests\Outputs\%BUILD_TARGET_NAME%\Tests\testG3d_ScreenCaptureWithEdit\%BUILD_TYPE%\Contents
set SAMPLE_CONTENT_DIR=%SIGLO_ROOT%\Samples\Sources\Applications\G3dDemo\TempResources\%BUILD_TARGET_NAME%

if "%TARGET%" equ "" (
    set TARGET=Build
)

echo %BUILD_TARGET_NAME% | "%WINDIR%\System32\find.exe" "v140" > NUL
if not errorlevel 1 (
    set VS_VERSION=VS2015
)

if %VS_VERSION%==VS2013 (
    call "%VS120COMNTOOLS%vsvars32.bat"
)
if %VS_VERSION%==VS2015 (
    call "%VS140COMNTOOLS%vsvars32.bat"
) 

if %SPEC%==Generic (
    set PROJFILE=%G3DDEMO_ROOT%\ConvertDemoResources-spec.Generic.csproj
    set CONFIGURATION=%VS_VERSION%_Release
) else (
    set PROJFILE=%G3DDEMO_ROOT%\ConvertDemoResources-spec.NX.csproj
    set CONFIGURATION=NX_%VS_VERSION%_RELEASE
)

if %OS%==win32 if %ADDRESS%==32 (
    set PLATFORM=Win32
) 
if %OS%==win32 if %ADDRESS%==64 (
    set PLATFORM=x64
)
if %OS%==horizon if %ADDRESS%==32 (
    set PLATFORM=NX32
)
if %OS%==horizon if %ADDRESS%==64 (
    set PLATFORM=NX64
)

rem MaleA.fmdb ̃obNAbv
set TOWN_SHADER_MODEL=%G3DDEMO_ROOT%\Resources\town\MaleA\MaleA.fmdb
set TOWN_TEMPORARY_BACKUP_FILE=%~dp0EditTownMaterialTemporary.fmdb
copy /Y %TOWN_SHADER_MODEL% %TOWN_TEMPORARY_BACKUP_FILE% > NUL

rem }eAQƂ̉
%ASSIGNUTIL% apply-parent-material "%TOWN_SHADER_MODEL%" --shader-path "%G3DDEMO_ROOT%\Resources\shader" -o "%TOWN_SHADER_MODEL%" --parent-material-path "%G3DDEMO_ROOT%\Resources\ParentMaterials"
if errorlevel 1 set RESULT=%ERRORLEVEL%

rem }eAQƏ̍폜
%ASSIGNUTIL% assign-parent-material "%TOWN_SHADER_MODEL%" --parent-material-assign "--parent-material ''"
if errorlevel 1 set RESULT=%ERRORLEVEL%

rem MaleA.fmdb ̃}eA
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_face, diffuse, 0.8 0.5 0.2"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_face, texsrt0, 1 0.5 0.5 90 0.1 0.1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_face, _a0, _s0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_eyeball, enable_lighting, 0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, enable_vertex_color, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, spec_int, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, spec_power, 0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, _s0, _a0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, enable_bake_texture, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, _b0, _x0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, _n0, _x0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, enable_indirect, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, ind_scale, 0.5 0.5"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, texsrt2, 1 0.5 0.5 90 0.1 0.1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, _a3, _x0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, _t0, _n0"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothB, enable_trans_texture, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothA, ice, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_clothA, culling, 1"
%FILTER% %TOWN_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "m_metal, blend, 3"

rem human_mini.fmdb ̃obNAbv
set DEMO_SHADER_MODEL=%G3DDEMO_ROOT%\Resources\human\human_mini.fmdb
set DEMO_TEMPORARY_BACKUP_FILE=%~dp0EditDemoMaterialTemporary.fmdb
copy /Y %DEMO_SHADER_MODEL% %DEMO_TEMPORARY_BACKUP_FILE% > NUL

rem human_mini.fmdb ̃}eA
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, diffuse, 0.8 0.5 0.2"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, texsrt0, 0 2 2 45 0.2 0.2"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, texsrt1, 0 2 2 45 0.2 0.2"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, texsrt2, 0 2 2 45 0.2 0.2"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, texsrt3, 0 2 2 45 0.2 0.2"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, multi_tex, 1"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, weight_tex, 0.5"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, _a1, _a0"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, spec_int, 1"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, spec_power, 0"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, spec_mask, 1"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, _s0, _a0"
%FILTER% %DEMO_SHADER_MODEL% --script %~dp0EditMaterial.py --argument "human_mini_m, rim_light, 0"

rem \[XRo[g
set RESULT=0
msbuild %PROJFILE% /t:%TARGET% /p:Configuration=%CONFIGURATION% /p:Platform=%PLATFORM%
if errorlevel 1 set RESULT=%ERRORLEVEL%

rem MaleA.fmdb ɖ߂
copy /Y %TOWN_TEMPORARY_BACKUP_FILE% %TOWN_SHADER_MODEL% > NUL
del %TOWN_TEMPORARY_BACKUP_FILE%

rem human_mini.fmdb ɖ߂
copy /Y %DEMO_TEMPORARY_BACKUP_FILE% %DEMO_SHADER_MODEL% > NUL
del %DEMO_TEMPORARY_BACKUP_FILE%

mkdir %CONTENT_DIR% > NUL 2>&1
xcopy /I /Y /S %SAMPLE_CONTENT_DIR% %CONTENT_DIR% > NUL

exit /b %RESULT%
