﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)
#define _CRTDBG_MAP_ALLOC
#include <cstdlib>
#include <crtdbg.h>
#endif

#include <nnt.h>
#include <nn/nn_Log.h>

namespace G3dTest{
    class ScopedMemoryLeakDetector
    {
    public:
        ScopedMemoryLeakDetector()
        {
            m_MemoryLeakDetector.Begin();
        }

        ~ScopedMemoryLeakDetector()
        {
            bool success = m_MemoryLeakDetector.End();
            EXPECT_EQ(true, success);
        }

    private:
        class MemoryLeakDetector
        {
        public:
            void Begin()
            {
#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)
                _CrtMemCheckpoint(&m_InitialMemoryState);
#endif
            }

            //! @brief メモリリークが検出されなければ true、そうでなければ false を返します。
            bool End()
            {
#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)
                _CrtMemCheckpoint(&m_FinalMemoryState);
                int memDifference = _CrtMemDifference(&m_MemoryStateDifference, &m_InitialMemoryState, &m_FinalMemoryState);
                if (memDifference != 0)
                {
                    size_t memoryLeakBytes = 0;
                    memoryLeakBytes += m_MemoryStateDifference.lSizes[_NORMAL_BLOCK];
                    memoryLeakBytes += m_MemoryStateDifference.lSizes[_CRT_BLOCK];
                    NN_LOG("Detected Memory Leaks! %u bytes\n", memoryLeakBytes);
                    _CrtMemDumpStatistics(&m_MemoryStateDifference);
                    return false;
                }

                return true;
#elif
                return true;
#endif
            }

        private:
#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)
            _CrtMemState m_InitialMemoryState;
            _CrtMemState m_FinalMemoryState;
            _CrtMemState m_MemoryStateDifference;
#endif
        };

        MemoryLeakDetector m_MemoryLeakDetector;
    };
}
