﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEft_ProgramOptions.h"

#include <cstdlib>
#include <cstring>
#include <cctype>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

namespace nnt{ namespace eft{

    static ProgramOptions g_ProgramOptionInstance = {};

    const ProgramOptions* ProgramOptions::GetInstancePointer()
    {
        return &g_ProgramOptionInstance;
    }

    void ProgramOptions::Parse(int argc, char** argv)
    {
        ProgramOptions* pOptions = &g_ProgramOptionInstance;

        for(int i = 1; i < argc; i++)
        {
            const char* arg = argv[i];

            if(std::strcmp(arg, "-ptcl") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->ptclPath = nnt::graphics::Path(argv[i + 1]).Normalize();
                i += 1;
            }
            else if(std::strcmp(arg, "-outDir") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->capturedImageDirectoryPath = nnt::graphics::Path(argv[i + 1]).Normalize();
                i += 1;
            }
            else if (std::strcmp(arg, "-width") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->screenWidth = std::atoi(argv[i + 1]);
                i++;
                continue;
            } else if (std::strcmp(arg, "-height") == 0)
            {
                NN_ASSERT(i + 1 < argc);
                pOptions->screenHeight = std::atoi(argv[i + 1]);
                i++;
                continue;
            }
            else
            {
                NN_LOG("unknown option: %s\n", arg);
            }
        }
    }

}}
