﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEft_HandlingCommand.h"
#include "testEft_HandlingTestSet.h"

using namespace std;


//------------------------------------------------------------------------------
//  コンストラクタです。
//------------------------------------------------------------------------------
HandlingTestSet::HandlingTestSet()
    : m_pEffectSystem(), m_pEsetHandle(), m_pCaptureFrames(), m_commands(), m_commandDebug()
    , m_frameNum(), m_commandIndex()
{
}


//------------------------------------------------------------------------------
//  デストラクタです。
//------------------------------------------------------------------------------
HandlingTestSet::~HandlingTestSet()
{
    // コマンドを破棄
    for (std::vector<HandlingCommand*>::iterator it = m_commands.begin(); it != m_commands.end(); )
    {
        if ( (*it) == 0 )
        {
            it = m_commands.erase( it );
            continue;
        }
        it++;
    }
}


//------------------------------------------------------------------------------
//  エフェクトシステムを設定します。
//------------------------------------------------------------------------------
void HandlingTestSet::SetEffectSystem( nn::vfx::System* pSystem )
{
    m_pEffectSystem = pSystem;
}


//------------------------------------------------------------------------------
//  エフェクトシステムを取得します。
//------------------------------------------------------------------------------
nn::vfx::System* HandlingTestSet::GetEffectSystem()
{
    return m_pEffectSystem;
}


//------------------------------------------------------------------------------
//  エフェクト操作ハンドルを設定します。
//------------------------------------------------------------------------------
void HandlingTestSet::SetEsetHandle( nn::vfx::Handle* pHandle )
{
    m_pEsetHandle = pHandle;
}


//------------------------------------------------------------------------------
//  エフェクト操作ハンドルを取得します。
//------------------------------------------------------------------------------
nn::vfx::Handle* HandlingTestSet::GetEsetHandle()
{
    return m_pEsetHandle;
}


//------------------------------------------------------------------------------
//  キャプチャーフレームを設定します。
//------------------------------------------------------------------------------
void HandlingTestSet::SetCaptureFrames( int* pFrames )
{
    m_pCaptureFrames = pFrames;
}


//------------------------------------------------------------------------------
//  キャプチャーフレームを取得します。
//------------------------------------------------------------------------------
const int* HandlingTestSet::GetCaptureFrames() const
{
    return m_pCaptureFrames;
}


//------------------------------------------------------------------------------
//  コマンドを追加します。
//------------------------------------------------------------------------------
void HandlingTestSet::AddCommand( HandlingCommand* pCommand, bool debug )
{
    m_commands.push_back( pCommand );
    m_commandDebug.push_back( debug );
}


//------------------------------------------------------------------------------
//  フレーム番号を設定します。
//------------------------------------------------------------------------------
void HandlingTestSet::SetFrameNum( int frameNum )
{
    m_frameNum = frameNum;
}


//------------------------------------------------------------------------------
//  フレーム番号を取得します。
//------------------------------------------------------------------------------
int HandlingTestSet::GetFrameNum() const
{
    return m_frameNum;
}


//------------------------------------------------------------------------------
//  操作コマンドを実行します。
//------------------------------------------------------------------------------
void HandlingTestSet::ExecuteCommands()
{
    int index = m_commandIndex;

    // コマンドを実行
    while ( index < (int)m_commands.size() && m_frameNum >= m_commands[index]->GetBeginFrame() )
    {
        // コマンドを実行
        if ( m_commands[index]->DoExecute( m_frameNum ) )
        {
            // デバッグブレーク
            if ( m_frameNum == m_commands[index]->GetBeginFrame() && m_commandDebug[index])
            {

#if NN_BUILD_CONFIG_OS_WIN
                __debugbreak();
#endif
            }

            HandlingCommand* pCommand = m_commands[index];
            pCommand->Execute( this );
        }

        ++index;
    }

    // コマンドインデックスを更新
    while ( m_commandIndex < (int)m_commands.size() && m_frameNum >= m_commands[m_commandIndex]->GetEndFrame() )
    {
        ++m_commandIndex;
    }
}


//------------------------------------------------------------------------------
//  キャプチャーを行うかどうか取得します。
//------------------------------------------------------------------------------
bool HandlingTestSet::DoCapture() const
{
    int i = 0;
    while ( m_pCaptureFrames[i] != -1 && m_pCaptureFrames[i] < m_frameNum ) ++i;

    return ( m_frameNum == m_pCaptureFrames[i] );
}


//------------------------------------------------------------------------------
//  テストが終わったかどうか取得します。
//------------------------------------------------------------------------------
bool HandlingTestSet::IsEnd() const
{
    int i = 0;
    while ( m_pCaptureFrames[i] != -1 && m_pCaptureFrames[i] <= m_frameNum ) ++i;

    return ( m_pCaptureFrames[i] == -1 );
}
