﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
//
#include <nn/gc/detail/gc_Util.h>
#include <nn/gc/detail/gc_StateMachine.h>

#include "testGc_Unit_GcLibrary_Util.h"

using namespace nn::gc;
using namespace nn::gc::detail;

StateMachine& gsm = StateMachine::GetInstance();
StateMachine::StateMachineForAsicHandler& gsmi = StateMachine::GetInstanceForAsicHandler();

TEST(GcUnitTest, StateMachineTest)
{
    gsmi.ResetState();
    TESTOUT(gsm.GetAsicState() == AsicState_Initial, "reset asic state");
    TESTOUT(gsm.GetGameCardMode() == GameCardMode_Initial, "reset gc state");
    TESTOUT(gsm.IsAsicSecure() == false, "not secure");

    {
        TESTOUT(gsm.GetAsicState() == AsicState_Initial, "asic power on (normal mode)");
        TESTOUT(gsm.GetGameCardMode() == GameCardMode_Initial, "reset gc state");
        TESTOUT(gsm.IsAsicSecure() == false, "not secure");

        gsmi.TransitStateWithSecureAsic();
        TESTOUT(gsm.GetAsicState() == AsicState_Secure, "asic secure mode");
        TESTOUT(gsm.GetGameCardMode() == GameCardMode_Initial, "reset gc state");
        TESTOUT(gsm.IsAsicSecure() == true, "secure");

        gsmi.TransitStateWithActivateGameCard();
        TESTOUT(gsm.GetAsicState() == AsicState_Secure, "asic secure mode");
        TESTOUT(gsm.GetGameCardMode() == GameCardMode_Normal, "activate");
        TESTOUT(gsm.IsAsicSecure() == true, "secure");

        gsmi.TransitStateWithSecureGameCard();
        TESTOUT(gsm.GetAsicState() == AsicState_Secure, "asic secure mode");
        TESTOUT(gsm.GetGameCardMode() == GameCardMode_Secure, "secure");
        TESTOUT(gsm.IsAsicSecure() == true, "secure");
    }

    // TODO

    gsmi.ResetState();
}

