﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// 本ヘッダを自動生成できれば、パターンを振ったテストを作成できると想定
// なので極力シンプルにする

namespace nnt { namespace gamepad {

    struct factors
    {
        nn::hid::NpadButtonSet buttons;             //!< Npad のデジタルボタンの状態です。
        nn::hid::AnalogStickState analogStickL;     //!< Npad の左アナログスティックの状態です。
        nn::hid::AnalogStickState analogStickR;     //!< Npad の右アナログスティックの状態です。
    };

    nn::hid::NpadButtonSet button;

    const int factorNum = 1;    //!< 因子数

    // 期待値
    // TODO：スティックを実際に倒すときに設定値を変更する
    const nnt::gamepad::factors ExpectedFactorTable[factorNum] = {
        { button.Reset(),{ 0, 0 },{ 0, 0 } },
    };

}} // namespace nnt::gamepad
