﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace gamepad {

//!< Npad のサンプリング間隔を返します。
inline ::nn::TimeSpanType GetNpadSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(5);
}

//!< Npad の入力状態を出力します。
template<typename TState>
inline void PrintNpadState(const TState& state) NN_NOEXCEPT
{
    NN_LOG("    SamplingNumber : %lld\n"
        , state.samplingNumber);
    NN_LOG("    AnalogStickL : (%d, %d)\n"
        , state.analogStickL.x, state.analogStickL.y);
    NN_LOG("    AnalogStickR : (%d, %d)\n"
        , state.analogStickR.x, state.analogStickR.y);
}

template<typename TState>
inline void PrintNpadButtonState(const TState& state)
{
    nn::hid::NpadButtonSet button = state.buttons;

    char buttons[29];
    buttons[0] = (button.Test<nn::hid::NpadButton::A>()) ? 'A' : '*';
    buttons[1] = (button.Test<nn::hid::NpadButton::B>()) ? 'B' : '*';
    buttons[2] = (button.Test<nn::hid::NpadButton::X>()) ? 'X' : '*';
    buttons[3] = (button.Test<nn::hid::NpadButton::Y>()) ? 'Y' : '*';
    buttons[4] = (button.Test<nn::hid::NpadButton::StickL>()) ? 'L' : '*';
    buttons[5] = (button.Test<nn::hid::NpadButton::StickL>()) ? 'S' : '*';
    buttons[6] = (button.Test<nn::hid::NpadButton::StickR>()) ? 'R' : '*';
    buttons[7] = (button.Test<nn::hid::NpadButton::StickR>()) ? 'S' : '*';
    buttons[8] = (button.Test<nn::hid::NpadButton::L>()) ? 'L' : '*';
    buttons[9] = (button.Test<nn::hid::NpadButton::R>()) ? 'R' : '*';
    buttons[10] = (button.Test<nn::hid::NpadButton::ZL>()) ? 'Z' : '*';
    buttons[11] = (button.Test<nn::hid::NpadButton::ZL>()) ? 'L' : '*';
    buttons[12] = (button.Test<nn::hid::NpadButton::ZR>()) ? 'Z' : '*';
    buttons[13] = (button.Test<nn::hid::NpadButton::ZR>()) ? 'R' : '*';
    buttons[14] = (button.Test<nn::hid::NpadButton::Plus>()) ? '+' : '*';
    buttons[15] = (button.Test<nn::hid::NpadButton::Minus>()) ? '-' : '*';
    buttons[16] = (button.Test<nn::hid::NpadButton::Left>()) ? '<' : '*';
    buttons[17] = (button.Test<nn::hid::NpadButton::Up>()) ? '^' : '*';
    buttons[18] = (button.Test<nn::hid::NpadButton::Right>()) ? '>' : '*';
    buttons[19] = (button.Test<nn::hid::NpadButton::Down>()) ? 'v' : '*';
    buttons[20] = (button.Test<nn::hid::NpadButton::StickLRight>()) ? '>' : '*';
    buttons[21] = (button.Test<nn::hid::NpadButton::StickLUp>()) ? '^' : '*';
    buttons[22] = (button.Test<nn::hid::NpadButton::StickLLeft>()) ? '<' : '*';
    buttons[23] = (button.Test<nn::hid::NpadButton::StickLDown>()) ? 'v' : '*';
    buttons[24] = (button.Test<nn::hid::NpadButton::StickRRight>()) ? '>' : '*';
    buttons[25] = (button.Test<nn::hid::NpadButton::StickRUp>()) ? '^' : '*';
    buttons[26] = (button.Test<nn::hid::NpadButton::StickRLeft>()) ? '<' : '*';
    buttons[27] = (button.Test<nn::hid::NpadButton::StickRDown>()) ? 'v' : '*';

    buttons[28] = '\n';

    NN_LOG("    Push Button is %s", buttons);
}

//!< Npadボタンのマスク値を取得します
//!< マスクしないと、スティックの倒した状態をボタンとして拾ってしまう
inline nn::hid::NpadButtonSet GetNpadMaskValue() NN_NOEXCEPT
{
    nn::hid::NpadButtonSet buttons;
    buttons.Reset();

    buttons.Set<nn::hid::NpadButton::A>();
    buttons.Set<nn::hid::NpadButton::B>();
    buttons.Set<nn::hid::NpadButton::X>();
    buttons.Set<nn::hid::NpadButton::Y>();
    buttons.Set<nn::hid::NpadButton::StickL>();
    buttons.Set<nn::hid::NpadButton::StickR>();
    buttons.Set<nn::hid::NpadButton::L>();
    buttons.Set<nn::hid::NpadButton::R>();
    buttons.Set<nn::hid::NpadButton::ZL>();
    buttons.Set<nn::hid::NpadButton::ZR>();
    buttons.Set<nn::hid::NpadButton::Plus>();
    buttons.Set<nn::hid::NpadButton::Minus>();
    buttons.Set<nn::hid::NpadButton::Left>();
    buttons.Set<nn::hid::NpadButton::Up>();
    buttons.Set<nn::hid::NpadButton::Right>();
    buttons.Set<nn::hid::NpadButton::Down>();

    return buttons;
}

}} // namespace nnt::gamepad
