﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nnd/ftm/ftm.h>

namespace nnt { namespace ftm {

// 定数に異常な値が入っていないことのテスト
TEST(ConstantTest, Basic)
{
    using namespace nnd::ftm;

    EXPECT_LT(1, FtmMaxTouchNumber);
    EXPECT_LT(1, FtmMaxEventReportCount);
    EXPECT_LT(1, static_cast<int>(FtmMaxEventReportByteSize));
}

// コントローラ固有の値に異常がないことのテスト
TEST(VariableTest, Basic)
{
    using namespace nnd::ftm;

    Initialize();
    EXPECT_LT(1, GetMaxTouchNumber());
    EXPECT_LT(1, GetMaxEventReportCount());
    EXPECT_LT(1, static_cast<int>(GetEventReportByteSize()));
    Finalize();
}

}}

