﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nnd/ftm/ftm.h>

extern "C" void nnMain()
{
    NN_LOG("/// FTM Fw Version Checker ///\n");

    nnd::ftm::Initialize();

    nn::Result result = nnd::ftm::ResetDevice();
    if (result.IsFailure())
    {
        NN_LOG("Module : %d, Description : %d, Inner : %d\n",
               result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }

    nnd::ftm::FirmwareVersion version;
    result = nnd::ftm::ReadFirmwareVersion(&version);
    if (result.IsFailure())
    {
        NN_LOG("Module : %d, Description : %d, Inner : %d\n",
               result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }

    NN_LOG("Release : 0x%08X, Program : 0x%04X, Configuration : 0x%04X\n",
           version.release, version.program, version.configuration);

    nnd::ftm::Finalize();

    NN_LOG("[[ PASSED !! ]]\n");
}
