﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>


void TestWriteReadStorage(nn::fs::IStorage* pStorage, size_t bufferSize = 512);
void TestWriteReadStorageWithLargeOffset(nn::fs::IStorage* pStorage, size_t bufferSize, char* writeBuffer) NN_NOEXCEPT;
void TestWriteReadStorageWithLargeOffset(nn::fs::IStorage* pStorage, size_t bufferSize) NN_NOEXCEPT;
void TestWriteReadStorageWithLargeOffset(nn::fs::fsa::IFile* pFile, size_t bufferSize) NN_NOEXCEPT;
void TestWriteReadStorageWithLargeOffsetAllowAppend(nn::fs::fsa::IFile* pFile, size_t bufferSize) NN_NOEXCEPT;
void TestBoundaryOffsetSize(nn::fs::IStorage* pStorage);
void TestBoundaryOffsetSize(nn::fs::IStorage* pStorage, size_t accessSizeMin);
void TestGetSize(nn::fs::IStorage* pStorage, int64_t expectedSize);
void TestStorageContent(nn::fs::IStorage* pStorage, size_t bufferSize = 512 * 1024);
void TestConcurrentWriteRead(nn::fs::IStorage* pStorage);

void TestRandomRangeRead(nn::fs::IStorage* pStorage, int testCount);

void TestFractionWriteRead(
    nn::fs::IStorage* pStorage, int64_t offset, size_t sizeBegin, size_t sizeEnd) NN_NOEXCEPT;

