﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssystem/fs_AesXtsStorage.h>
#include <nn/fssystem/fs_NcaFileSystemDriver.h>
#include <nn/fssystem/buffers/fs_IBufferManager.h>

namespace nnt { namespace fs { namespace util {

class NcaReaderBuilder
{
public:
    struct Buffer
    {
        void* ptr;
        size_t size;
    };

    static const int BlockSize = 512 * 1024;

public:
    NcaReaderBuilder() NN_NOEXCEPT;
    explicit NcaReaderBuilder(bool isPatch) NN_NOEXCEPT;

    std::shared_ptr<nn::fssystem::NcaReader> Make() NN_NOEXCEPT;
    std::shared_ptr<nn::fssystem::NcaReader> MakePatch() NN_NOEXCEPT;

    const Buffer GetStorageBuffer() NN_NOEXCEPT;
    const Buffer GetPatchStorageBuffer() NN_NOEXCEPT;
    const Buffer GetFs0Data() NN_NOEXCEPT;
    const Buffer GetFs1Data() NN_NOEXCEPT;
    const Buffer GetNewData() NN_NOEXCEPT;

private:
    void BuildStorage() NN_NOEXCEPT;
    void BuildPatchStorage() NN_NOEXCEPT;
    void BuildPatchData() NN_NOEXCEPT;

private:
    std::unique_ptr<char[]> m_DataBuffer;
    nnt::fs::util::Vector<char> m_NewDataBuffer;
    std::unique_ptr<char[]> m_StorageBuffer;
    std::unique_ptr<char[]> m_PatchStorageBuffer;
};

nn::fssystem::IBufferManager* GetBufferManager() NN_NOEXCEPT;
void SignNcaHeader(void* pOutValue, size_t outSize, const nn::fssystem::NcaHeader& ncaHeader) NN_NOEXCEPT;
void MakeAesXtsIv(void* pOutValue, size_t outSize, int64_t baseOffset) NN_NOEXCEPT;

extern const uint8_t BodyAesKey[4][nn::fssystem::AesXtsStorage::KeySize];
extern const uint8_t Rsa2048KeyPrivateExponent[nn::fssystem::NcaCryptoConfiguration::Rsa2048KeyPrivateExponentSize];
extern const nn::fssystem::NcaCryptoConfiguration CryptoConfiguration;

}}}
