﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_TestContext.h"

class StressTestMountHostFs : public StressTestMountInfoBase
{
public:
    StressTestMountHostFs() NN_NOEXCEPT
    {
    }

    virtual ~StressTestMountHostFs() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    //! マウント
    void Mount() NN_NOEXCEPT
    {
        m_HostDirectory.Create();
        NNT_ASSERT_RESULT_SUCCESS(
            nn::fs::MountHost(
                GetMountName(),
                m_HostDirectory.GetPath().c_str()
            )
        );
    }

    //! アンマウント
    void Unmount() NN_NOEXCEPT
    {
        nn::fs::Unmount(GetMountName());
        m_HostDirectory.Delete();
    }

private:
    nnt::fs::util::TemporaryHostDirectory m_HostDirectory;
};
