﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsUtil/testFs_util.h>
#include "testFs_Stress_AccessDirectoriesTestCase.h"

namespace nnt { namespace fs {

class RenameDirectoriesTestCase : public AccessDirectoriesTestCase
{
public:
    RenameDirectoriesTestCase(int threadCount, int fileCount) NN_NOEXCEPT
        : AccessDirectoriesTestCase(threadCount, fileCount, 5)
    {
    }

    virtual ~RenameDirectoriesTestCase() NN_NOEXCEPT NN_OVERRIDE {}

    virtual int GetLoopCount() const NN_NOEXCEPT NN_OVERRIDE
    {
        return 10;
    }

    virtual void Test(FsStressTest* pTest, int threadIndex) NN_NOEXCEPT NN_OVERRIDE
    {
        Fail(threadIndex);

        ASSERT_FALSE(pTest->IsReadOnly(GetTestCaseIndex()));
        for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
        {
            char path[PathLength];
            char renamedPath[PathLength];
            MakePath(path, GetEntryIndex(threadIndex, entryIndex));
            nn::util::SNPrintf(renamedPath, sizeof(renamedPath), "%s_renamed", path);
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::RenameDirectory(path, renamedPath));
            NNT_ASSERT_RESULT_SUCCESS(nn::fs::RenameDirectory(renamedPath, path));
        }

        Succeed(threadIndex);
    }
};

class RenameDirectories : public RenameDirectoriesTestCase
{
public:
    RenameDirectories() NN_NOEXCEPT
        : RenameDirectoriesTestCase(FsStressTest::ThreadCountMax, 10)
    {
    }
};

class RenameFewerDirectories : public RenameDirectoriesTestCase
{
public:
    RenameFewerDirectories() NN_NOEXCEPT
        : RenameDirectoriesTestCase(FsStressTest::ThreadCountMax / 2, 10)
    {
    }
};

TEST_F(SaveDataFsStressTest, RenameDirectories)
{
    Test<RenameDirectories>(GetMountName());
}

TEST_F(MultipleSaveDataFsStressTest, RenameDirectories)
{
    Test<RenameFewerDirectories, RenameFewerDirectories>(GetMountName(0), GetMountName(1));
}

TEST_F(OtherApplicationSaveDataFsStressTest, RenameDirectories)
{
    Test<RenameDirectories>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)
TEST_F(HostFsStressTest, RenameDirectories)
{
    Test<RenameDirectories>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_HOST_FS)

TEST_F(SdCardFsStressTest, RenameDirectories)
{
    Test<RenameDirectories>(GetMountName());
}

#if defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)
TEST_F(TemporaryStorageFsStressTest, RenameDirectories)
{
    Test<RenameDirectories>(GetMountName());
}
#endif // defined(NNT_FS_STRESS_TEST_SUPPORTS_TEMPORARY_STORAGE)

}}
