﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_OpenEntriesTestCase.h"

namespace nnt { namespace fs {

class AccessDirectoriesTestCase : public OpenEntriesTestCase
{
public:
    AccessDirectoriesTestCase(
        int threadCount,
        int entryCount,
        int subentryCount) NN_NOEXCEPT;
    virtual ~AccessDirectoriesTestCase() NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetUp(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TearDown(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;

protected:
    int GetSubentryCount() const NN_NOEXCEPT
    {
        return m_SubentryCount;
    }

private:
    int m_SubentryCount;
};

}}
