﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/init/init_Malloc.h>
#include <nn/ns/ns_AppletLauncherApi.h>
#include <nn/ns/ns_InitializationApi.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

TEST(AccessPriority, LaunchAndWaitSystemProgram)
{
    nn::ns::Initialize();
    NN_UTIL_SCOPE_EXIT
    {
        nn::ns::Finalize();
    };

    nn::os::ProcessId processId;
    nn::ncm::SystemProgramId sysId = { 0x0005000C10000001 };
    NNT_ASSERT_RESULT_SUCCESS(nn::ns::LaunchLibraryApplet(&processId, sysId));

    nn::os::SystemEvent event;
    nn::ns::GetApplicationShellEvent(&event);
    event.Wait();

    const auto eventInfoArrayLength = 256;
    auto eventInfoBuffer = nnt::fs::util::AllocateBuffer(sizeof(nn::ns::ApplicationShellEventInfo) * eventInfoArrayLength);
    ASSERT_TRUE(eventInfoBuffer);
    auto* pEventInfo = reinterpret_cast<nn::ns::ApplicationShellEventInfo*>(eventInfoBuffer.get());
    {
        const auto infoCount = nn::ns::PopApplicationShellEventInfo(pEventInfo, eventInfoArrayLength);
        for( auto i = 0; i < infoCount; ++i )
        {
            if( pEventInfo[i].processId == processId )
            {
                ASSERT_EQ(nn::ns::ApplicationShellEvent::Exit, pEventInfo[i].event);
            }
        }
    }
}

extern "C" void nninitStartup()
{
    static char s_Buffer[16 * 1024 * 1024];
    nn::init::InitializeAllocator(s_Buffer, sizeof(s_Buffer));
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);

    auto testResult = RUN_ALL_TESTS();

    nnt::Exit(testResult);
}
