﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Content.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

#include "testFs_FsLib_Mount.h"

namespace
{
    const nn::ncm::ApplicationId ApplicationId = { 0x0005000C10000000 };
    const nn::ncm::ProgramId ProgramId = { 0x0005000C10000000 };

    const nnt::fs::util::MountTestAttribute GetAttribute() NN_NOEXCEPT
    {
        nnt::fs::util::MountTestAttribute attribute = {};
        attribute.isReservedMountNameSupported = true;
        return attribute;
    }

    // MountContent(const char* name, ncm::ProgramId id, ContentType contentType)
    nn::Result MountContentType4ForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        NN_RESULT_DO(nn::ns::MountApplicationHtmlDocument(mountName, ApplicationId));
        nn::fs::Unmount(mountName);

        NN_RESULT_DO(nn::fs::MountContent(mountName, ProgramId, nn::fs::ContentType_Manual));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountContentType4", MountContentType4ForMountNameTest, nullptr, GetAttribute },
    };
}

NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountContent2, ::testing::ValuesIn(MountTestParameters));
