﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>
#include <nn/lmem/lmem_Common.h>

#include <nn/fs/fs_ResultHandler.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

// アライメントずれテストアプリ

TEST(Allocator, SetAllocatorAlignmentViolation_Death)
{
    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);

    // SetAllocationPointerOffset のテスト
    EXPECT_DEATH_IF_SUPPORTED(nnt::fs::util::SetAllocationPointerOffset(-1), "");

    const size_t allocSize = 1024;
    for(int offset = 1; offset < 1024; ++offset)
    {
        nnt::fs::util::SetAllocationPointerOffset(offset);
        auto p = nnt::fs::util::Allocate(allocSize);
        ASSERT_NE(p, nullptr);
        ASSERT_TRUE(nn::util::is_aligned(reinterpret_cast<uintptr_t>(p) - offset, nn::lmem::DefaultAlignment));
        nnt::fs::util::Deallocate(p, allocSize);
    }
    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    // 8バイトオフセットは成功
    nnt::fs::util::SetAllocationPointerOffset(8);
    NNT_EXPECT_RESULT_SUCCESS(nn::fs::MountHostRoot());
    nn::fs::UnmountHostRoot();

    // 4バイトオフセットは失敗
    nnt::fs::util::SetAllocationPointerOffset(4);
    EXPECT_DEATH_IF_SUPPORTED(nn::fs::MountHostRoot(), "");
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nn::fs::SetEnabledAutoAbort(false);
    nnt::fs::util::ResetAllocateCount();

    auto testResult = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(testResult);
}
