﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

# ** ボタンを押すスクリプト
# StartTime 秒待機
# 5 秒待機し B を押す。これを 4 回押す。
# 20 秒待機し A を押す。5秒待機し A を押す。これを 2 回繰り返す
# 20 秒待機
# StartTime 秒待機
# 5 秒待機し B を押す。これを 4 回押す。
# 20 秒待機し A を押す。5秒待機し A を押す。これを 2 回繰り返す

param
(
    [Parameter(Mandatory=$true)]
    [string]
    # SDEV の名前
    $Target,

    [Parameter(Mandatory=$true)]
    [int]
    # ボタンを押し始めるまでの時間
    $StartTime
)

# ボタンを押す関数
function PushButton {
    param( [string] $ButtonId )
    try
    {
        Invoke-CriticalCommand "& `"$HidShell`" send-event --target `"$Target`" Xpad Basic0 ButtonDown $ButtonId"
        Invoke-CriticalCommand "& `"$HidShell`" send-event --target `"$Target`" Xpad Basic0 ButtonUp $ButtonId"
        Write-Output "Push $ButtonId Success."
    }
    catch
    {
        Write-Output "Push $ButtonId Failed."
        Sleep 1
    }
}

# SdkRootPath 取得関数とファイル存在確認関数の読み込み
$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}/../../../../../../../Integrate/Scripts/Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../../../../../Integrate/Scripts/Modules/Utility"

# HidShell のパスを取得
$HidShell = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/Hid/HidShell.exe"
Test-EnsureExistPath $HidShell

# ボタン入力待機
Write-Output "Wait $StartTime sec"

$loop_cnt = 0
while ( $loop_cnt -le 2 )
{
    # StartTime 秒待機
    Sleep $StartTime

    # 5 秒待機し B を押す。これを 4 回繰り返す。
    $cnt = 0
    while ( $cnt -le 4 )
    {
        PushButton("B")
        Sleep 5
        $cnt++
    }

    # 20 秒待機し A を押す。5秒待機し A を押す。これを 2 回繰り返す
    $cnt = 0
    while ( $cnt -le 2 )
    {
        Sleep 20
        PushButton("A")
        Sleep 5
        PushButton("A")
        $cnt++
    }

    # 20 秒待機
    Sleep 20
    $loop_cnt++
}
