﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/fs/fs_Result.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nnt/nntest.h>
#include <nnt/fsApi/testFs_Api.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>

using namespace nn::fs;
using namespace nn::fs::fsa;
using namespace nnt::fs::util;

namespace nnt { namespace fs { namespace api {
    void LoadTargetInUseRoTests()
    {
        return;
    }

    class TargetInUseRoFile
        : public GetFileSystemTestFixture, public ::testing::WithParamInterface<OpenMode>
    {
    protected:
        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::SetUp();
            m_LockedFileName = GetTestRootPath().append("/TargetInUseRo/locked.file");
            NNT_ASSERT_RESULT_SUCCESS(
                GetFs().OpenFile(&m_File, m_LockedFileName.c_str(), GetParam()));
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            m_File.reset(nullptr);
            GetFileSystemTestFixture::TearDown();
        }
    protected:
        String m_LockedFileName;
    private:
        std::unique_ptr<ITestFile> m_File;
    };

    class TargetInUseRoDirectory
        : public GetFileSystemTestFixture, public ::testing::WithParamInterface<OpenDirectoryMode>
    {
    protected:
        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::SetUp();
            m_LockedDirectoryName = GetTestRootPath().append("/TargetInUseRo/lockedDir");
            NNT_ASSERT_RESULT_SUCCESS(
                GetFs().OpenDirectory(&m_Dir, m_LockedDirectoryName.c_str(), GetParam()));
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            m_Dir.reset(nullptr);
            GetFileSystemTestFixture::TearDown();
        }
    protected:
        String m_LockedDirectoryName;
    private:
        std::unique_ptr<ITestDirectory> m_Dir;
    };

    class TargetInUseRoFileWithOpenModeRead : public TargetInUseRoFile
    {
    };

    TEST_P(TargetInUseRoFile, GetEntryType)
    {
        DirectoryEntryType directoryEntryType;
        NNT_EXPECT_RESULT_SUCCESS(
            GetFs().GetEntryType(&directoryEntryType, m_LockedFileName.c_str()));
        EXPECT_EQ(directoryEntryType, DirectoryEntryType_File);
    }

    TEST_P(TargetInUseRoFileWithOpenModeRead, OpenFile)
    {
        std::unique_ptr<ITestFile> file;
        NNT_EXPECT_RESULT_SUCCESS(GetFs().OpenFile(&file, m_LockedFileName.c_str(), OpenMode_Read));
        file.reset(nullptr);

//        NNT_EXPECT_RESULT_FAILURE(ResultTargetLocked, GetFs().OpenFile(&file, m_LockedFileName.c_str(), OpenMode_Write));
//        NNT_EXPECT_RESULT_FAILURE(ResultTargetLocked, GetFs().OpenFile(&file, m_LockedFileName.c_str(), static_cast<OpenMode>(OpenMode_Write | OpenMode_AllowAppend)));
    }

    const OpenMode AllOpenMode[] = {
        OpenMode_Read,
//        OpenMode_Write,
//        static_cast<OpenMode>(OpenMode_Read | OpenMode_Write),
//        static_cast<OpenMode>(OpenMode_Write | OpenMode_AllowAppend),
//        static_cast<OpenMode>(OpenMode_Read | OpenMode_Write | OpenMode_AllowAppend)
    };

    INSTANTIATE_TEST_CASE_P(WithOpenMode,
                            TargetInUseRoFile,
                            ::testing::ValuesIn(AllOpenMode));

    INSTANTIATE_TEST_CASE_P(WithOpenMode,
                            TargetInUseRoFileWithOpenModeRead,
                            ::testing::Values(OpenMode_Read));

    const OpenDirectoryMode AllOpenDirectoryMode[] = {
        OpenDirectoryMode_Directory,
        OpenDirectoryMode_File,
        OpenDirectoryMode_All
    };

    TEST_P(TargetInUseRoDirectory, GetEntryType)
    {
        DirectoryEntryType directoryEntryType;
        NNT_EXPECT_RESULT_SUCCESS(
            GetFs().GetEntryType(&directoryEntryType, m_LockedDirectoryName.c_str()));
        EXPECT_EQ(directoryEntryType, DirectoryEntryType_Directory);
    }

    TEST_P(TargetInUseRoDirectory, OpenDirectory)
    {
        for( auto openDirectoryMode : AllOpenDirectoryMode )
        {
            std::unique_ptr<ITestDirectory> directory;
            NNT_EXPECT_RESULT_SUCCESS(
                GetFs().OpenDirectory(
                    &directory, m_LockedDirectoryName.c_str(), openDirectoryMode));
        }
    }

    INSTANTIATE_TEST_CASE_P(WithOpenDirectoryMode,
        TargetInUseRoDirectory,
        ::testing::ValuesIn(AllOpenDirectoryMode));
}}}
