﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApi/testFs_Api.h>

namespace nnt { namespace fs { namespace api {
    void LoadOpenModeTests() NN_NOEXCEPT
    {
        return;
    }

    namespace {
        const int FileSize = 32;

        const nn::fs::OpenMode OpenFileModesRead[] =
        {
            nn::fs::OpenMode_Read,
            static_cast<nn::fs::OpenMode>(nn::fs::OpenMode_Read | nn::fs::OpenMode_AllowAppend),
        };

        const nn::fs::OpenMode OpenFileModesWrite[] =
        {
            nn::fs::OpenMode_Write,
            static_cast<nn::fs::OpenMode>(nn::fs::OpenMode_Write | nn::fs::OpenMode_AllowAppend),
        };
    }

    class OpenModeTest : public CleanupFileSystemTestFixture
    {
    protected:

        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            CleanupFileSystemTestFixture::SetUp();
            m_FileName = GetTestRootPath().append("/test.file");
            NNT_ASSERT_RESULT_SUCCESS(GetFs().CreateFile(m_FileName.c_str(), FileSize));
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            CleanupFileSystemTestFixture::TearDown();
        }

        const util::String& GetFileName() NN_NOEXCEPT
        {
            return m_FileName;
        }
    private:
        util::String m_FileName;
    };

    //! @brief 読み込みモード/書き込みモードのどちらかで開いたファイルを Flush し、ResultSuccess が返却されることを確認する
    TEST_F(OpenModeTest, FlushFile)
    {
        for( auto openMode : OpenFileModesRead )
        {
            std::unique_ptr<ITestFile> file;

            NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), openMode));
            NNT_EXPECT_RESULT_SUCCESS(file->Flush());
        }

        for( auto openMode : OpenFileModesWrite )
        {
            std::unique_ptr<ITestFile> file;

            NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), openMode));
            NNT_EXPECT_RESULT_SUCCESS(file->Flush());
        }
    }

    //! @brief 読み込みモード/書き込みモードのどちらかで開いたファイルを GetSize し、ResultSuccess が返却されることを確認する
    TEST_F(OpenModeTest, GetFileSize)
    {
        int64_t fileSize;

        for( auto openMode : OpenFileModesRead )
        {
            std::unique_ptr<ITestFile> file;

            NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), openMode));
            NNT_EXPECT_RESULT_SUCCESS(file->GetSize(&fileSize));
        }

        for( auto openMode : OpenFileModesWrite )
        {
            std::unique_ptr<ITestFile> file;

            NNT_ASSERT_RESULT_SUCCESS(GetFs().OpenFile(&file, GetFileName().c_str(), openMode));
            NNT_EXPECT_RESULT_SUCCESS(file->GetSize(&fileSize));
        }
    }

}}}
