﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

namespace
{
    nn::account::Uid s_Users[nn::account::UserCountMax] = {};
    int s_UserCount = 0;
}

class FriendsNotificationSettings : public testing::Test
{
public:
    static void SetUpTestCase() NN_NOEXCEPT
    {
        nn::account::Initialize();

        nnt::friends::LoadAccounts(&s_UserCount, s_Users, NN_ARRAY_SIZE(s_Users));
        NN_ABORT_UNLESS_GREATER_EQUAL(s_UserCount, 1);
    }

    static void TearDownTestCase() NN_NOEXCEPT
    {
    }
};

TEST_F(FriendsNotificationSettings, SetDefault)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>(true);
    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>(true);
    settings.friendPresenceOverlayPermission = static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_NotConfirmed);

    for (int i = 0; i < s_UserCount; i++)
    {
        settings.uid = s_Users[i];
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::SetNotificationSettings(s_Users[i], settings));
    }

    for (int i = 0; i < s_UserCount; i++)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNotificationSettings(&settings, s_Users[i]));

        EXPECT_EQ(settings.uid, s_Users[i]);
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendOnline>());
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendRequest>());
        EXPECT_EQ(settings.friendPresenceOverlayPermission, static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_Friends));
    }
}

TEST_F(FriendsNotificationSettings, GetDefault)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    nn::settings::system::SetAccountNotificationSettings(&settings, 0);

    for (int i = 0; i < s_UserCount; i++)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNotificationSettings(&settings, s_Users[i]));

        EXPECT_EQ(settings.uid, s_Users[i]);
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendOnline>());
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendRequest>());
        EXPECT_EQ(settings.friendPresenceOverlayPermission, static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_Friends));
    }
}

TEST_F(FriendsNotificationSettings, Set1)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>(false);
    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>(false);
    settings.friendPresenceOverlayPermission = static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_NoDisplay);

    for (int i = 0; i < s_UserCount; i++)
    {
        settings.uid = s_Users[i];
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::SetNotificationSettings(s_Users[i], settings));
    }

    for (int i = 0; i < s_UserCount; i++)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNotificationSettings(&settings, s_Users[i]));

        EXPECT_EQ(settings.uid, s_Users[i]);
        EXPECT_FALSE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendOnline>());
        EXPECT_FALSE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendRequest>());
        EXPECT_EQ(settings.friendPresenceOverlayPermission, static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_NoDisplay));
    }
}

TEST_F(FriendsNotificationSettings, Set2)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>(true);
    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>(false);
    settings.friendPresenceOverlayPermission = static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_FavoriteFriends);

    for (int i = 0; i < s_UserCount; i++)
    {
        settings.uid = s_Users[i];
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::SetNotificationSettings(s_Users[i], settings));
    }

    for (int i = 0; i < s_UserCount; i++)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNotificationSettings(&settings, s_Users[i]));

        EXPECT_EQ(settings.uid, s_Users[i]);
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendOnline>());
        EXPECT_FALSE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendRequest>());
        EXPECT_EQ(settings.friendPresenceOverlayPermission, static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_FavoriteFriends));
    }
}

TEST_F(FriendsNotificationSettings, Set3)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>(false);
    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>(true);
    settings.friendPresenceOverlayPermission = static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_Friends);

    for (int i = 0; i < s_UserCount; i++)
    {
        settings.uid = s_Users[i];
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::SetNotificationSettings(s_Users[i], settings));
    }

    for (int i = 0; i < s_UserCount; i++)
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::friends::GetNotificationSettings(&settings, s_Users[i]));

        EXPECT_EQ(settings.uid, s_Users[i]);
        EXPECT_FALSE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendOnline>());
        EXPECT_TRUE(settings.flags.Test<nn::settings::system::AccountNotificationFlag::FriendRequest>());
        EXPECT_EQ(settings.friendPresenceOverlayPermission, static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_Friends));
    }
}

TEST_F(FriendsNotificationSettings, Invalid)
{
    nn::settings::system::AccountNotificationSettings settings = {};

    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>(false);
    settings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>(false);
    settings.friendPresenceOverlayPermission = static_cast<int8_t>(nn::settings::system::FriendPresenceOverlayPermission_NotConfirmed);

    NNT_EXPECT_RESULT_FAILURE(nn::friends::ResultInvalidArgument, nn::friends::SetNotificationSettings(nn::account::InvalidUid, settings));
}
