﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testFriends_Common.h"

#include <nn/friends/detail/service/json/friends_Json.h>
#include <nn/friends/detail/service/json/friends_JsonApi.h>
#include <nn/friends/detail/service/json/friends_JsonPatchGenerator.h>

using namespace nn::friends::detail::service::json;

TEST(FriendsJsonPatch, Writer)
{
    FixedSizeAllocator allocator;

    JsonMemoryOutputStream os;
    char buffer[1024];

    os.Open(buffer, sizeof (buffer));
    os.PutBegin();

    JsonWriter writer(os, &allocator, 16);

    EXPECT_TRUE(JsonPatchGenerator::BeginWrite(writer));
    {
        EXPECT_TRUE(JsonPatchGenerator::BeginWriteReplaceOperation(writer, "/permissions/presence"));
        {
            EXPECT_TRUE(writer.String("FAVORITE_FRIENDS"));
        }
        EXPECT_TRUE(JsonPatchGenerator::EndWriteReplaceOperation(writer));
        EXPECT_TRUE(JsonPatchGenerator::WriteMoveOperation(writer, "/extras/self/key1", "/extras/favoriteFriends/key1"));
    }
    EXPECT_TRUE(JsonPatchGenerator::EndWrite(writer));

    size_t written = os.PutEnd();

    os.Close();

    const char* expect =
    "["
        "{"
            "\"op\":\"replace\",\"path\":\"/permissions/presence\",\"value\":\"FAVORITE_FRIENDS\""
        "}"
        ","
        "{"
            "\"op\":\"move\",\"from\":\"/extras/self/key1\",\"path\":\"/extras/favoriteFriends/key1\""
        "}"
    "]";

    EXPECT_STREQ(buffer, expect);

    JsonMemoryInputStream is;

    is.Open(buffer, written);

    char stringBuffer[256];
    char streamBuffer[256];
    is.SetBuffer(stringBuffer, sizeof (stringBuffer), streamBuffer, sizeof (streamBuffer));

    JsonPrintEventHandler handler;
    nn::friends::detail::service::util::Cancelable cancelable;

    NNT_EXPECT_RESULT_SUCCESS(nn::friends::detail::service::json::Parse(handler, is, cancelable));

    is.Close();
}
