﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/fgm.h>
#include <nn/nn_Log.h>
#include <nnt/nntest.h>

namespace nnt { namespace fgm {

struct Target
{
    nn::fgm::Module module;
    nn::fgm::Setting setting;
};

}} // namespace nnt::fgm

class FgmMemoryTest: public ::testing::TestWithParam<nnt::fgm::Target>{};

namespace {

const int MemoryLeakIterations = 1000;

const nnt::fgm::Target Targets[] =
{
    { nn::fgm::Module_Cpu,     1224000000 },
    { nn::fgm::Module_Gpu,      460800000 },
    { nn::fgm::Module_Emc,     1065600000 },
    { nn::fgm::Module_SysBus,  nn::fgm::Setting_Min },
    { nn::fgm::Module_Mselect, nn::fgm::Setting_Min },
    { nn::fgm::Module_Nvdec,   nn::fgm::Setting_Min },
    { nn::fgm::Module_Nvenc,   nn::fgm::Setting_Min },
    { nn::fgm::Module_Nvjpg,   nn::fgm::Setting_Min },
    { nn::fgm::Module_Test,    nn::fgm::Setting_Min },
};

} // namespace

INSTANTIATE_TEST_CASE_P(FgmMemoryLeakTestModules, FgmMemoryTest, testing::ValuesIn(Targets));

// *** Memory leak test *** //
TEST_P(FgmMemoryTest, MemoryLeak)
{
    nn::Result result;
    nn::fgm::Request request;

    for (int i = 0; i < MemoryLeakIterations; ++i)
    {
        EXPECT_TRUE((result = request.Initialize(GetParam().module, nn::fgm::Priority_Highest)).IsSuccess());
        EXPECT_TRUE((result = request.Set(GetParam().setting, GetParam().setting)).IsSuccess());
        ASSERT_TRUE((result = request.Finalize()).IsSuccess());

        nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(1000));
    }
}

TEST_P(FgmMemoryTest, AllocateMemoryLeak)
{
    nn::Result result;

    for (int i = 0; i < MemoryLeakIterations; ++i)
    {
        nn::fgm::Request* request = new nn::fgm::Request;
        EXPECT_TRUE((result = request->Initialize(GetParam().module, nn::fgm::Priority_Highest)).IsSuccess());
        EXPECT_TRUE((result = request->Set(GetParam().setting, GetParam().setting)).IsSuccess());
        ASSERT_TRUE((result = request->Finalize()).IsSuccess());

        nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(1000));
    }

}
