﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include <nn/fatal/fatal_ApiPrivate.h>
#include <nn/fatal/fatal_Api.h>
#include <nn/fatalsrv/fatalsrv_FatalEventManager.h>

extern "C" void _start() {}

namespace {
    class FatalEventTest : public testing::Test
    {
    protected:
        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
        }

        static void TearDownTestCase()
        {
        }


    private:
    };
}

TEST_F(FatalEventTest, Default)
{
    nn::fatal::SetFatalPolicy(nn::fatal::FatalPolicy_Default);

    // FatalEvent は MaxEventCount 個しか取得できない。
    // システム起動時に am と audio がそれぞれ一つづつ取得するのでテストでは am と audio が取得する合計 2 つ分を引いて最大個まで取得する。
    // このテストを一度実行した後再実行するためにはシステムを再起動する必要がある。
    const int FatalEventCount = nn::fatalsrv::FatalEventManager::MaxEventCount - 2; // am と audio が取得する分を引いている
    nn::os::SystemEvent events[FatalEventCount];

    for (int i = 0; i < FatalEventCount; ++i)
    {
        nn::fatal::GetFatalEvent(&events[i]);
    }

    {
        // OnlyErrorRepot 時は FatalEvent がシグナルされない
        nn::fatal::SetFatalPolicy(nn::fatal::FatalPolicy_OnlyErrorReport);
        nn::fatal::ThrowFatal(nn::ResultSuccess());
        for (int i = 0; i < FatalEventCount; ++i)
        {
            EXPECT_FALSE(events[i].TryWait());
        }
    }

    {
        // Default 時は FatalEvent がシグナルされない
        nn::fatal::SetFatalPolicy(nn::fatal::FatalPolicy_Default);
        nn::fatal::ThrowFatal(nn::ResultSuccess());
        for (int i = 0; i < FatalEventCount; ++i)
        {
            EXPECT_TRUE(events[i].TryWait());
        }
    }
}

// INFO: Default テストで fatal するのでこの後にはテストケースを書けない。
