﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <random>

#include <nnt/nntest.h>
#include <nn/fs.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Tick.h>

#include <nn/escore/escore.h>
#include <nnt/escoreUtil/testEscore_util_istorage.h>

USING_ESCORE_UTIL_NAMESPACE
USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE
//#include <esitypes.h>
#include <nn/ioscrypto/iosctypes.h>


#include "../Common/testEs_Est_utils.h"

/* TODO: dynamically generate the following files */
#include "../Common/testEs_Ca_cert_new.cpp"
#include "../Common/testEs_Cp_cert_new.cpp"
#include "../Common/testEs_Xs_cert_new.cpp"

#if !defined( ES_TEST_MEMORY_CONSTRAINT )
#include "../Common/testEs_Tkt5.cpp"

static u8 __outTicketBuf[1024 * 1024];
#endif

#if defined( DO_MAX_TICKET_TEST )
static char s_ticketFileIn[] = "00000005.tik";
#else
static char s_ticketFileIn[] = "00000002.tik";
#endif

/* Hardcoded info */
#ifdef ES_TEST_EXPORT_CONTENT_DATA
const u64 ES_TEST_TITLE_ID = 0x5000007700000099ULL;
#endif


/* Certificates */
const int ES_TEST_CERT_CHAIN_LEN = 3; /* CA, XS, CP */

static const void *__certs[ES_TEST_CERT_CHAIN_LEN + 2] = {caNewCert, xsNewCert, cpNewCert, NULL, NULL};
static u32 __nCerts = ES_TEST_CERT_CHAIN_LEN;


#ifdef ES_TEST_EXPORT_CONTENT_DATA
static u8 __outBuf[2048] ATTR_AES_ALIGN;
static u8 __contextBuf[1024] ATTR_AES_ALIGN;
#endif

static ESError __testSetup()
{
    return ES_ERR_OK;
}

static const char *makeAbsPath( const char *fileName )
{
    static std::string path;

    //#define NNT_ES_SIGLO_ROOT set by nact script or vcxporj to the root path of Siglo.
    const char* kResourcePath = "/Tests/Escore/Sources/Tests/Stress/testEs_Stress/";
    path = std::string(NNT_ES_SIGLO_ROOT) + std::string(kResourcePath) + fileName;

    return path.c_str();
}

static ESError __testMaxTicket()
{
    ESError rv = ES_ERR_OK;

    ETicketService es;
    ETicket ticket;

#if !defined( ES_TEST_MEMORY_CONSTRAINT )
    MemoryInputStream ticketStream( tkt5, sizeof( tkt5 ) );
#else
    FileStream ticketStream;
    FileStream outTicketStream;

    if( !( ticketStream.TryInitialize( makeAbsPath(s_ticketFileIn), OPEN_MODE_READ ).IsSuccess() ) )
    {
        ES_TEST_LOG( "Failed to initialize ticket stream\n" );
        rv = ES_ERR_FAIL;
        goto end;
    }
#endif

    rv = ticket.Set( ticketStream, __certs, __nCerts, true );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set the ticket, rv=%d\n", rv );
        goto end;
    }
    ES_TEST_LOG( "Set the maximum size ticket\n" );

end:
    return rv;
}  // NOLINT (readability/fn_size)

static ESError __testCleanup()
{
    return ES_ERR_OK;
}

/**
    @brief FS用アロケータ
 */
void* Allocate(size_t size)
{
    return std::malloc(size);
}

/**
    @brief FS用デアロケータ
 */
void Deallocate(void* p, size_t size)
{
    NN_UNUSED(size);
    std::free(p);
}

TEST( StressTest, Stress )
{
    ESError rv = ES_ERR_OK;

    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fs::MountHostRoot();

    rv = __testSetup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testMaxTicket();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    rv = __testCleanup();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

end:
    if( rv == ES_ERR_OK )
    {
        ES_TEST_LOG( "***** Passed stress tests *****\n" );
    }

    return;
}
