﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished proprietary information of BroadOn Communications Corp.,
 *  and are protected by Federal copyright law. They may not be disclosed
 *  to third parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>
#include <nn/nn_Macro.h>

#define TESTNAME "KeyGenTest"
#define NEED_NUMTICKS

#include "testEs_Testcommon.h"

#include <nn/ioscrypto/iosccert.h>

#define ERROR_CHECK( err )                \
    if( err != IOSC_ERROR_OK )            \
    {                                     \
        LOG_FAIL( "error in IOSC call" ); \
        EXIT( -1 );                       \
    }

NN_ALIGNAS( ALIGN_SIZE ) u8 data[IOSC_AES_BLOCKSIZE_BYTES];
NN_ALIGNAS( ALIGN_SIZE ) u8 dataout1[IOSC_AES_BLOCKSIZE_BYTES];
NN_ALIGNAS( ALIGN_SIZE ) u8 dataout2[IOSC_AES_BLOCKSIZE_BYTES];
NN_ALIGNAS( ALIGN_SIZE ) u8 iv[IOSC_AES_BLOCKSIZE_BYTES];

NN_ALIGNAS( ALIGN_SIZE ) static IOSCEccSignedCert appcert;
#ifdef USE_OBSOLETE_CODE
IOSError createEncryptedRandomsKeyGen( IOSCSecretKeyHandle handle, u8 *iv, u8 *rand, u32 size )
{
    IOSCError error;
    int i;
    /* Encrypt randoms - somewhere else ! */
    for( i = 0; i < size; i++ )
    {
        rand[i] = i;
    }
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }
    error = IOSC_Encrypt( handle, iv, rand, size, rand );
    if( error != IOSC_ERROR_OK )
    {
        return error;
    }
    /* reset IV */
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }
    return error;
}
#endif

int doKeyGenTest()
{
    IOSCSecretKeyHandle firstprivh, secondprivh;
    IOSCPublicKeyHandle firstpubh, secondpubh;

    IOSCSecretKeyHandle firsthmac, secondhmac;
    IOSCSecretKeyHandle firstenc, secondenc;
    IOSCKeyHandle keypair1, keypair2;
    IOSCEccPublicKey eccpublickey1, eccpublickey2;

    int iter;

    IOSCEccPrivateKey eccprivatekey1, eccprivatekey2;
    IOSCHmacKey hmackey1, hmackey2;
    IOSCCertName appname;

    s32 err;
    int i;

#ifdef PERF
    u32 startTime, endTime;
#endif

    /*
     * Test of ComputeSharedKey
     */
    for( iter = 0; iter < 10; iter++ )
    {
        err = IOSC_CreateObject( &firstprivh, IOSC_SECRETKEY_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );
        err = IOSC_CreateObject( &secondprivh, IOSC_SECRETKEY_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );

        for( i = 0; i < sizeof( eccprivatekey1 ); i++ )
        {
            eccprivatekey1[i] = static_cast<u8>( i + iter );
            eccprivatekey2[i] = static_cast<u8>( i + 1 );
        }
        err = IOSC_ImportSecretKey( firstprivh, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, eccprivatekey1 );
        ERROR_CHECK( err );

        err = IOSC_ImportSecretKey( secondprivh, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, eccprivatekey2 );
        ERROR_CHECK( err );

        /* import public keys: get them by getting certs */
        memset( appname, 0x0, sizeof( IOSCCertName ) );
        memcpy( appname, "APP00000001", sizeof( "APP00000001" ) );
        /*
        #ifdef RVL
                err = createEncryptedRandomsKeyGen(IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof(randBuffer));
                ERROR_CHECK(err);
                err = IOSC_GenerateCertificateWithRandoms (firstprivh, appname, &appcert, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE);
        #else
        */
        err = IOSC_GenerateCertificate( firstprivh, appname, &appcert );
        /*
        #endif
        */
        ERROR_CHECK( err );

        err = IOSC_CreateObject( &firstpubh, IOSC_PUBLICKEY_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );
        err = IOSC_ImportPublicKey( ( (IOSCEccEccCert *)appcert )->pubKey, 0, firstpubh );
        ERROR_CHECK( err );
        /*
        #ifdef RVL
                err = createEncryptedRandomsKeyGen(IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof(randBuffer));
                ERROR_CHECK(err);
                err = IOSC_GenerateCertificateWithRandoms (secondprivh, appname, &appcert, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE);
        #else
        */
        err = IOSC_GenerateCertificate( secondprivh, appname, &appcert );
        /*
        #endif
        */
        ERROR_CHECK( err );
        err = IOSC_CreateObject( &secondpubh, IOSC_PUBLICKEY_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );
        err = IOSC_ImportPublicKey( ( (IOSCEccEccCert *)appcert )->pubKey, 0, secondpubh );
        ERROR_CHECK( err );

        /* put shared keys in these handles */
        err = IOSC_CreateObject( &firsthmac, IOSC_SECRETKEY_TYPE, IOSC_MAC_SUBTYPE );
        ERROR_CHECK( err );
        err = IOSC_CreateObject( &secondhmac, IOSC_SECRETKEY_TYPE, IOSC_MAC_SUBTYPE );
        ERROR_CHECK( err );
#ifdef PERF
        startTime = IO_READ( SYS_TIMER_REG );
#endif
        err = IOSC_ComputeSharedKey( firstprivh, secondpubh, firsthmac );
#ifdef PERF
        endTime = IO_READ( SYS_TIMER_REG );
        if( iter == 0 )
        {
            NN_LOG( "Number of Ticks for IOSC_ComputeSharedKey (ECC)= %d, Time = %d us\n", getNumTicks( startTime, endTime ),
                    getNumTicks( startTime, endTime ) * NUM_TICKS / CLOCK_FREQ );
        }
#endif
        ERROR_CHECK( err );
        err = IOSC_ComputeSharedKey( secondprivh, firstpubh, secondhmac );
        ERROR_CHECK( err );
        err = IOSC_ExportSecretKey( firsthmac, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, hmackey1 );
        ERROR_CHECK( err );
        err = IOSC_ExportSecretKey( secondhmac, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, hmackey2 );
        ERROR_CHECK( err );

        if( memcmp( hmackey1, hmackey2, sizeof( IOSCHmacKey ) ) != 0 )
        {
            LOG_FAIL( "Shared key computation, imported keys, iter = %d", iter );
            EXIT( -1 );
        }
        else
        {
            LOG_PASS( "Shared key computation, imported keys, iter = %d", iter );
        }

        /* Negative test: change one priv key, shared key should not match*/
        eccprivatekey1[2] ^= 0x01;
        err = IOSC_ImportSecretKey( firstprivh, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, eccprivatekey1 );
        ERROR_CHECK( err );
        err = IOSC_ComputeSharedKey( firstprivh, secondpubh, firsthmac );
        ERROR_CHECK( err );
        err = IOSC_ExportSecretKey( firsthmac, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, hmackey1 );
        ERROR_CHECK( err );
        if( memcmp( hmackey1, hmackey2, sizeof( IOSCHmacKey ) ) == 0 )
        {
            LOG_FAIL( "Shared key computation, imported keys Neg Test, iter = %d", iter );
            EXIT( -1 );
        }
        else
        {
            LOG_PASS( "Shared key computation, imported keys Neg Test, iter = %d", iter );
        }

        IOSC_DeleteObject( firstprivh );
        IOSC_DeleteObject( secondprivh );
        IOSC_DeleteObject( firstpubh );
        IOSC_DeleteObject( secondpubh );
        IOSC_DeleteObject( firsthmac );
        IOSC_DeleteObject( secondhmac );
    }

    /*
     * Test of key pair generation and ComputeSharedKey
     */
    for( iter = 0; iter < 10; iter++ )
    {
        err = IOSC_CreateObject( &keypair1, IOSC_KEYPAIR_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );
#ifdef PERF
        startTime = IO_READ( SYS_TIMER_REG );
#endif
        /*
        #ifdef RVL
                err = createEncryptedRandomsKeyGen(IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof(randBuffer));
                ERROR_CHECK(err);
                IOSC_GenerateKeyWithRandoms(keypair1, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE);
        #else
        */
        err = IOSC_GenerateKey( keypair1 );
/*
#endif
*/

#ifdef PERF
        endTime = IO_READ( SYS_TIMER_REG );
        if( iter == 0 )
        {
            NN_LOG( "Number of Ticks for IOSC_GenerateKey (ECC Key Pair)= %d, Time  = %d us\n", getNumTicks( startTime, endTime ),
                    getNumTicks( startTime, endTime ) * NUM_TICKS / CLOCK_FREQ );
        }
#endif
        ERROR_CHECK( err );
        err = IOSC_ExportPublicKey( eccpublickey1, 0, keypair1 );
        ERROR_CHECK( err );

        err = IOSC_CreateObject( &keypair2, IOSC_KEYPAIR_TYPE, IOSC_ECC233_SUBTYPE );
        ERROR_CHECK( err );
        /*
        #ifdef RVL
                err = createEncryptedRandomsKeyGen(IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof(randBuffer));
                ERROR_CHECK(err);
                err = IOSC_GenerateKeyWithRandoms(keypair2, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE);
        #else
        */
        err = IOSC_GenerateKey( keypair2 );
        /*
        #endif
        */
        ERROR_CHECK( err );

        err = IOSC_ExportPublicKey( eccpublickey2, 0, keypair2 );
        ERROR_CHECK( err );
        /* put shared keys in these handles */
        err = IOSC_CreateObject( &firstenc, IOSC_SECRETKEY_TYPE, IOSC_ENC_SUBTYPE );
        ERROR_CHECK( err );
        err = IOSC_CreateObject( &secondenc, IOSC_SECRETKEY_TYPE, IOSC_ENC_SUBTYPE );
        ERROR_CHECK( err );

        err = IOSC_ComputeSharedKey( keypair1, keypair2, firstenc );
        ERROR_CHECK( err );
        err = IOSC_ComputeSharedKey( keypair2, keypair1, secondenc );
        ERROR_CHECK( err );
        for( i = 0; i < IOSC_AES_BLOCKSIZE_BYTES; i++ )
        {
            data[i] = static_cast<u8>( i );
            iv[i] = static_cast<u8>( i + 1 );
        }
        err = IOSC_Encrypt( firstenc, iv, data, IOSC_AES_BLOCKSIZE_BYTES, dataout1 );
        ERROR_CHECK( err );
        for( i = 0; i < IOSC_AES_BLOCKSIZE_BYTES; i++ )
        {
            data[i] = static_cast<u8>( i );
            iv[i] = static_cast<u8>( i + 1 );
        }
        err = IOSC_Encrypt( secondenc, iv, data, IOSC_AES_BLOCKSIZE_BYTES, dataout2 );
        ERROR_CHECK( err );


        IOSC_DeleteObject( keypair1 );
        IOSC_DeleteObject( keypair2 );
        IOSC_DeleteObject( firstenc );
        IOSC_DeleteObject( secondenc );

        if( memcmp( dataout1, dataout2, sizeof( IOSC_AES_BLOCKSIZE_BYTES ) ) != 0 )
        {
            LOG_FAIL( "Shared key computation, generated keys, iter = %d", iter );
            EXIT( -1 );
        }
        else
        {
            LOG_PASS( "Shared key computation, generated keys, iter = %d", iter );
        }
    }

    return 0;
}  // NOLINT (readability/fn_size)


#if defined( SEPARATE_MAIN_PROGRAM )

int main( int argc, char **argv )
{
    IOSC_Initialize();
    doKeyGenTest();
    EXIT( 0 );
    return 0;
}
#endif
