﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testEns_TaskThreadStatistics.h"

namespace nnt { namespace ens {

TaskThreadStatistics::TaskThreadStatistics() NN_NOEXCEPT
    : m_pTlsSlot(nullptr)
    , m_Span(0)
{
}

TaskThreadStatistics::~TaskThreadStatistics() NN_NOEXCEPT
{
}

void TaskThreadStatistics::SetParameter(nn::os::TlsSlot* pTlsSlot, nn::TimeSpan span) NN_NOEXCEPT
{
    m_pTlsSlot = pTlsSlot;
    m_Span = span;
}

nn::Result TaskThreadStatistics::Main() NN_NOEXCEPT
{
    nn::os::SetTlsValue(*m_pTlsSlot, nn::os::GetTlsValue(*m_pTlsSlot) + 1);

    NN_RESULT_DO(StepWait());

    NN_RESULT_SUCCESS;
}

nn::Result TaskThreadStatistics::StepWait() NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(!GetCancelEvent().TimedWait(m_Span), nn::ens::ResultCanceledByUser());

    NN_RESULT_SUCCESS;
}

}}
