﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testEns_Common.h"

#include <nn/ens/detail/util/ens_DataHolder.h>

TEST(EnsDataHolder, Integer8_1)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.s64 = -1;
    holder.integer.isSigned = true;

    int8_t s8;
    EXPECT_TRUE(holder.Get(&s8));

    int16_t s16;
    EXPECT_TRUE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_FALSE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_FALSE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_FALSE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer8_2)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.u64 = 0;
    holder.integer.isSigned = false;

    int8_t s8;
    EXPECT_TRUE(holder.Get(&s8));

    int16_t s16;
    EXPECT_TRUE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_TRUE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_TRUE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer16_1)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.s64 = INT8_MAX + 1;
    holder.integer.isSigned = true;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_TRUE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_TRUE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_TRUE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer16_2)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.u64 = INT8_MAX + 1;
    holder.integer.isSigned = false;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_TRUE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_TRUE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_TRUE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer32_1)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.s64 = INT16_MAX + 1;
    holder.integer.isSigned = true;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_FALSE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_TRUE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer32_2)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.u64 = INT16_MAX + 1;
    holder.integer.isSigned = false;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_FALSE(holder.Get(&s16));

    int32_t s32;
    EXPECT_TRUE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_TRUE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer64_1)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.s64 = INT32_MAX + 1ll;
    holder.integer.isSigned = true;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_FALSE(holder.Get(&s16));

    int32_t s32;
    EXPECT_FALSE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_FALSE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer64_2)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.u64 = INT32_MAX + 1ull;
    holder.integer.isSigned = false;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_FALSE(holder.Get(&s16));

    int32_t s32;
    EXPECT_FALSE(holder.Get(&s32));

    int64_t s64;
    EXPECT_TRUE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_FALSE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_TRUE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Integer64_3)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Integer};

    holder.integer.u64 = INT64_MAX + 1ull;
    holder.integer.isSigned = false;

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));

    int16_t s16;
    EXPECT_FALSE(holder.Get(&s16));

    int32_t s32;
    EXPECT_FALSE(holder.Get(&s32));

    int64_t s64;
    EXPECT_FALSE(holder.Get(&s64));

    uint8_t u8;
    EXPECT_FALSE(holder.Get(&u8));

    uint16_t u16;
    EXPECT_FALSE(holder.Get(&u16));

    uint32_t u32;
    EXPECT_FALSE(holder.Get(&u32));

    uint64_t u64;
    EXPECT_TRUE(holder.Get(&u64));
}

TEST(EnsDataHolder, Boolean)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Boolean};

    holder.boolean = true;

    bool boolean;
    EXPECT_TRUE(holder.Get(&boolean));

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));
}

TEST(EnsDataHolder, Double)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Float};

    holder.float64 = 0.25;

    double f64;
    EXPECT_TRUE(holder.Get(&f64));

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));
}

TEST(EnsDataHolder, String)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_String};

    holder.string.pValue = "12345";
    holder.string.length = 5;

    char str[6] = {};
    EXPECT_TRUE(holder.Get(str, 6));
    EXPECT_STREQ(str, holder.string.pValue);

    EXPECT_FALSE(holder.Get(str, 5));

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));
}

TEST(EnsDataHolder, Binary)
{
    nn::ens::detail::util::DataHolder holder = {nn::ens::detail::util::DataHolderType_Binary};

    holder.binary.pValue = "12345";
    holder.binary.length = 5;

    nn::Bit8 binary[5] = {};
    size_t size;

    EXPECT_TRUE(holder.Get(&size, binary, 5));
    EXPECT_EQ(size, 5u);
    EXPECT_TRUE(std::memcmp(binary, holder.binary.pValue, 5) == 0);

    EXPECT_FALSE(holder.Get(&size, binary, 4));

    int8_t s8;
    EXPECT_FALSE(holder.Get(&s8));
}
