﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#if defined(NN_BUILD_CONFIG_OS_WIN)

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#endif // NN_BUILD_CONFIG_OS_WIN

#include <nn/ens.h>
#include <nn/ens/ens_ResultPublic.h>
#include <nn/ens/ens_ResultPrivate.h>
#include <nn/ens/detail/ens_LibrarySettings.h>
#include <nn/ens/detail/core/ens_ServiceThread.h>

#include <nn/os.h>
#include <nn/time.h>
#include <nn/nifm.h>
#include <nn/socket.h>
#include <nn/util/util_ScopeExit.h>

#include <curl/curl.h>
