﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nns {

typedef struct Color
{
    float rRatio;
    float gRatio;
    float bRatio;
    float aRatio;
    Color()
    {
        this->rRatio = 0.0f;
        this->gRatio = 0.0f;
        this->bRatio = 0.0f;
        this->aRatio = 1.0f;
    }
    Color(float rRatio, float gRatio, float bRatio, float aRatio)
    {
        this->rRatio = rRatio;
        this->gRatio = gRatio;
        this->bRatio = bRatio;
        this->aRatio = aRatio;
    }
} Color;

class DisplayConfig
{
public:
    static const int CharBufferLength = 512;

    virtual ~DisplayConfig() {}
    virtual int GetConfigCount() NN_NOEXCEPT;
    virtual const char* GetConfigCaption(int index) NN_NOEXCEPT;
    virtual const char* GetConfigStatus(int index) NN_NOEXCEPT;
    virtual const char* GetConfigLabel(int index) NN_NOEXCEPT;
    virtual void SetConfig(int index, bool isAscending) NN_NOEXCEPT;
    virtual void UpdateConfig() NN_NOEXCEPT;
    virtual bool IsSceneSwitched() NN_NOEXCEPT;
    virtual const Color& GetBackGroundColor() NN_NOEXCEPT;
};

}
