<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Performs OneTouchPlay on the device and then plays a tone based on TvParameters.ps1

    .DESCRIPTION
        Enables and disables the test SDEV and makes sure it becomes the active source accordingly
        For sleep/wake, ensures the test SDEV goes to sleep when told to through CEC
#>

param
(
    [Parameter(Mandatory=$True)]
    [String]
    # The ip address of the target
    $TargetAddress,
    
    [Parameter(Mandatory=$True)]
    [Int]
    # The tone to be emitted by the test target
    $Tone,
    
    [Parameter(Mandatory=$False)]
    [Int]
    # The amplitude for the test target and remote control's tone
    $Amplitude = 100,
    
    [Parameter(Mandatory=$True)]
    [String]
    # The ip address of the microphone server
    $ServerAddress
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

. "${scriptDirectoryPath}\Common.ps1"

Initialize-Consts

Write-Host "--------------------------"
Write-Host "Getting EDID..."
Write-Host "--------------------------"
$edid = Get-Tv-Edid $TargetAddress
Update-Tv-Parameters $edid
$Amplitude = Apply-Amplitude-Multiplier $Tone $Amplitude

Write-Host "--------------------------"
Write-Host "Attempting OneTouchPlay..."
Write-Host "--------------------------"
& $RunOnTargetExe "${scriptDirectoryPath}\RemoteControl.nsp" -t $TargetAddress -- -OneTouchPlay

Write-Host "--------------------------"
Write-Host "Toggling tone ${Tone}..."
Write-Host "--------------------------"
& "${scriptRootPath}/Tests/Outputs/Win32-v140/Tests/ToggleTone/Develop/ToggleTone.exe" -ipAddr $ServerAddress -tone $Tone

Write-Host "--------------------------"
Write-Host "Playing tone at amplitude ${Amplitude}..."
Write-Host "--------------------------"
& $RunOnTargetExe "${scriptDirectoryPath}\PlayTone.nsp" --no-wait -t $TargetAddress -- -frequency $Tone -amplitude $Amplitude
